/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.Crypto;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.monitoring.jmx.JMXConnectorNotifier;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyObserver;
import com.cognos.pogo.monitoring.jmx.utils.PogoJmxProperties;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXDispatcherConnection
implements JMXConnectorNotifier,
NotificationListener {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final Date DATE_EPOCH = new Date(0L);
    private static ICCLConfiguration cclconfig = CCLConfigurationFactory.getInstance();
    private String jmxUrl;
    private MBeanServerConnection mbeanServerConnection;
    private JMXConnector cntor;
    private String name;
    private Crypto cryptoFacility;
    private Date connectionAttempt = DATE_EPOCH;
    private long connectInterval;

    protected JMXDispatcherConnection(String dispatcherName, String jmxUrl) {
        this(dispatcherName, jmxUrl, new CryptoFacility(), JMXDispatcherConnection.getConnectInterval());
    }

    private static long getConnectInterval() {
        int timeout = PogoJmxProperties.getProxyHessianTimeout();
        return timeout * 2;
    }

    public JMXDispatcherConnection(String dispatcherName, String jmxUrl, Crypto cryptoFacility, long connectInterval) {
        this.name = dispatcherName;
        this.jmxUrl = jmxUrl;
        this.cryptoFacility = cryptoFacility;
        this.connectInterval = connectInterval;
    }

    public synchronized MBeanServerConnection getMbeanServerConnection() {
        if (this.mbeanServerConnection == null) {
            this.connect();
        }
        return this.mbeanServerConnection;
    }

    @Override
    public void connect() {
        if (this.isLocalDispatcher()) {
            this.mbeanServerConnection = PogoMBeanServer.getInstance().getServer();
            return;
        }
        Date currentTime = new Date();
        if (currentTime.getTime() - this.connectionAttempt.getTime() >= this.connectInterval) {
            this.connectionAttempt = new Date();
            this.remoteConnect();
            if (this.mbeanServerConnection != null) {
                this.connectionAttempt = DATE_EPOCH;
            }
        }
    }

    protected void remoteConnect() {
        this.cntor = null;
        try {
            JMXServiceURL url = new JMXServiceURL(this.jmxUrl);
            HashMap<String, Object> environment = new HashMap<String, Object>();
            String password = cclconfig.getValue("disp_sharedsecret", false);
            byte[] token = this.cryptoFacility.getToken(password.getBytes());
            environment.put("jmx.remote.credentials", token);
            Long serverConnectionTimeout = PogoMBeanServer.getInstance().getServerConnectionTimeout();
            environment.put("HessianConnectionTimeout", serverConnectionTimeout);
            this.cntor = this.getConnectorFromFactory(url, environment);
            cat.debug("Connected to URL ", this.jmxUrl, " with connection ID ", this.cntor.getConnectionId());
            this.mbeanServerConnection = this.cntor.getMBeanServerConnection();
            this.setCloseOnFailure();
        }
        catch (SecurityException x) {
            this.disconnect();
            throw x;
        }
        catch (CAMCryptoException e) {
            this.disconnect();
            cat.error("CAM Crypto error: ", e);
            throw new SecurityException();
        }
        catch (IOException e) {
            this.disconnect();
            cat.info("IOException connecting to " + this.jmxUrl, e);
        }
        catch (CCLConfigurationException e) {
            this.disconnect();
            cat.error("Unable to get shared secret from CCL Configuration", e);
        }
        catch (Exception e) {
            this.disconnect();
            cat.info("Exception connecting to " + this.jmxUrl, e);
        }
    }

    protected JMXConnector getConnectorFromFactory(JMXServiceURL url, Map<String, Object> environment) throws IOException {
        return JMXConnectorFactory.connect(url, environment);
    }

    private void setCloseOnFailure() {
        this.cntor.addConnectionNotificationListener(this, null, null);
    }

    private void closeConnector() {
        if (this.cntor != null) {
            try {
                cat.debug("Closing connector ", this.cntor.getConnectionId());
                this.cntor.close();
            }
            catch (IOException e) {
                cat.debug("Exception closing connection ", e);
            }
        }
    }

    boolean isLocalDispatcher() {
        NodeID elementNode = NodeID.getNodeID(this.name);
        if (elementNode != null) {
            return elementNode.isLocalToSelf();
        }
        return false;
    }

    @Override
    public boolean canConnect() {
        if (this.getMbeanServerConnection() == null) {
            return false;
        }
        try {
            this.getMbeanServerConnection().getMBeanCount();
        }
        catch (IOException e) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        if (notificationListener != null && this.cntor != null) {
            this.cntor.addConnectionNotificationListener(notificationListener, null, this.jmxUrl);
        }
    }

    @Override
    public void disconnect() {
        this.closeConnector();
        this.mbeanServerConnection = null;
    }

    public boolean isConnected() {
        return this.mbeanServerConnection != null;
    }

    public void startMonitoring(ProxyObserver listener, String proxyJmxUrl) {
        this.startMonitoring(listener);
    }

    @Override
    public void startMonitoring(final ProxyObserver listener) {
        this.setNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                JMXConnectionNotification jmxConnectionNotification;
                if (notification instanceof JMXConnectionNotification && !(jmxConnectionNotification = (JMXConnectionNotification)notification).getType().equals("jmx.remote.connection.opened")) {
                    listener.update((String)handback);
                }
            }
        });
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof JMXConnectionNotification && this.isConnectionLost(notification)) {
            cat.debug("Lost connection to ", this.jmxUrl, " disconnecting.");
            this.disconnect();
        }
    }

    private boolean isConnectionLost(Notification notification) {
        JMXConnectionNotification jmxConnectionNotification = (JMXConnectionNotification)notification;
        return "jmx.remote.connection.failed".equals(jmxConnectionNotification.getType());
    }
}

