/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnection;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.HashMap;

public class JMXDispatcherConnectionFactory {
    private static final HashMap<String, JMXDispatcherConnection> connectionCache = new HashMap();

    public static synchronized JMXDispatcherConnection createConnection(String dispatcherName, String jmxUrl) {
        String lowerDispatcherName = dispatcherName.toLowerCase();
        JMXDispatcherConnection jmxDispatcherConnection = connectionCache.get(lowerDispatcherName);
        if (jmxDispatcherConnection == null) {
            jmxDispatcherConnection = new JMXDispatcherConnection(lowerDispatcherName, jmxUrl);
            connectionCache.put(lowerDispatcherName, jmxDispatcherConnection);
        }
        return jmxDispatcherConnection;
    }

    public JMXDispatcherConnection createConnection(String jmxUrl) {
        return JMXDispatcherConnectionFactory.createConnection(this.extractNameFromUrl(jmxUrl), jmxUrl);
    }

    private String extractNameFromUrl(String jmxUrl) {
        return MBeanUtils.getHostFromUrl(jmxUrl);
    }
}

