/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.proxy.ConsolidatedMBeanCreator;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportMonitorCreator;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerFactory;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import javax.management.JMException;
import javax.management.MBeanServer;

public class LocalMBeanHookup {
    private static PogoLogger cat = PogoLogger.getLogger();
    private ThresholdManager thresholdManager;

    public void finishLocalDispatcher(String localSearchPath) {
        this.finishLocalDispatcher(localSearchPath, ThresholdManagerFactory.getThresholdManager());
    }

    public void finishLocalDispatcher(String localSearchPath, ThresholdManager thresholdManager) {
        this.thresholdManager = thresholdManager;
        this.thresholdManager.setLocalSearchPath(localSearchPath);
        this.createConsolidatedMBeans(localSearchPath);
        this.startHessianConnector();
    }

    private void createConsolidatedMBeans(String localSearchPath) {
        this.createInteractiveReportMBeans();
        this.registerThresholdManager();
        ConsolidatedMBeanCreator beanCreator = new ConsolidatedMBeanCreator(this.thresholdManager, localSearchPath);
        beanCreator.createConsolidatedMBeans();
        this.thresholdManager.recreateThresholds();
    }

    private void startHessianConnector() {
        PogoMBeanServer.getInstance().startHessianConnector();
    }

    private void createInteractiveReportMBeans() {
        InteractiveReportMonitorCreator monitorCreator = new InteractiveReportMonitorCreator();
        monitorCreator.createMBeans();
    }

    private void registerThresholdManager() {
        try {
            MBeanServer mbeanServer = PogoMBeanServer.getInstance().getServer();
            mbeanServer.registerMBean(this.thresholdManager, MBeanUtils.createObjectNameInstance("type=ThresholdManager"));
        }
        catch (JMException e) {
            cat.error("unable to register ThresholdManager", e);
        }
    }
}

