/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.jmx.DispatcherServerGroup;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherList;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanList;
import com.cognos.pogo.monitoring.jmx.proxy.UpdateGroupsInterface;
import com.cognos.pogo.monitoring.jmx.utils.MBeanRepositoryFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanRepository {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanRepository.class.getName());
    private Map<ObjectName, DynamicMBean> repositoryHash = new HashMap<ObjectName, DynamicMBean>();
    private HashSet<String> services;
    private DispatcherServerGroup dispatcherServerGroup;
    private MBeanServer proxyServer;

    public MBeanRepository() {
    }

    public MBeanRepository(MBeanServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    private MBeanServer getProxyServer() {
        return this.proxyServer != null ? this.proxyServer : PogoMBeanServer.getInstance().getProxyMBeanServer();
    }

    public synchronized void put(ObjectName proxyName, DynamicMBean proxy) {
        this.repositoryHash.put(proxyName, proxy);
    }

    public synchronized void remove(ObjectName metricName) {
        this.repositoryHash.remove(metricName);
    }

    public synchronized DynamicMBean get(ObjectName metricName) {
        return this.repositoryHash.get(metricName);
    }

    public synchronized MBeanRepository getPattern(ObjectName pattern) {
        MBeanRepository matching = new MBeanRepository();
        this.getObjects(matching, pattern);
        return matching;
    }

    public synchronized DynamicMBean getAny(ObjectName pattern) {
        Iterator<Map.Entry<ObjectName, DynamicMBean>> iter = this.iterator();
        while (iter.hasNext()) {
            Map.Entry<ObjectName, DynamicMBean> target = iter.next();
            ObjectName targetKey = target.getKey();
            if (!pattern.apply(targetKey)) continue;
            return target.getValue();
        }
        return null;
    }

    public synchronized HashSet<String> getServices() {
        this.services = new HashSet();
        for (ObjectName objectName : this.getObjectNames()) {
            String serviceName = objectName.getKeyProperty("service");
            if (serviceName == null) continue;
            this.services.add(serviceName);
        }
        return this.services;
    }

    public synchronized Collection<ObjectName> getObjectNames() {
        return this.repositoryHash.keySet();
    }

    public synchronized Collection<DynamicMBean> getMBeans() {
        return this.repositoryHash.values();
    }

    public synchronized Map<ObjectName, DynamicMBean> getMBeanHash() {
        return new HashMap<ObjectName, DynamicMBean>(this.repositoryHash);
    }

    public synchronized Iterator<Map.Entry<ObjectName, DynamicMBean>> iterator() {
        return this.repositoryHash.entrySet().iterator();
    }

    public synchronized void clear() {
        this.repositoryHash.clear();
    }

    public MBeanRepository getExpandedDispatchers(ObjectName pattern) {
        String groupName = pattern.getKeyProperty("group");
        JMXDispatcherList dispatcherList = this.dispatcherServerGroup.getDispatchersForGroup(groupName);
        MBeanRepository expandedRepository = new MBeanRepository();
        Iterator<JMXDispatcher> iter = dispatcherList.completeIterator();
        while (iter.hasNext()) {
            JMXDispatcher dispatcher = iter.next();
            try {
                ObjectName dispatcherObject = this.getObjectNameForDispatcher(pattern, dispatcher);
                this.getObjects(expandedRepository, dispatcherObject);
            }
            catch (MalformedObjectNameException e) {
                cat.debug("ignored malformed object name", (Throwable)e);
            }
        }
        return expandedRepository;
    }

    private void getObjects(MBeanRepository expandedRepository, ObjectName dispatcherObject) {
        if (dispatcherObject.isPattern()) {
            this.getMatchingPattern(dispatcherObject, expandedRepository);
        } else {
            DynamicMBean mBean = this.get(dispatcherObject);
            if (mBean != null) {
                expandedRepository.put(dispatcherObject, mBean);
            }
        }
    }

    private void getMatchingPattern(final ObjectName pattern, MBeanRepository matching) {
        this.addFilteredToRepository(matching, new MBeanRepositoryFilter(){

            @Override
            public boolean matches(ObjectName objectName, DynamicMBean mBean) {
                return pattern.apply(objectName);
            }
        });
    }

    private ObjectName getObjectNameForDispatcher(ObjectName pattern, JMXDispatcher dispatcher) throws MalformedObjectNameException {
        Hashtable<String, String> propertyList = pattern.getKeyPropertyList();
        propertyList.remove("group");
        propertyList.put("dispatcher", ObjectName.quote(dispatcher.getName()));
        ObjectName objectName = new ObjectName(pattern.getDomain(), propertyList);
        if (pattern.isPropertyPattern()) {
            String objectNameString = objectName.toString();
            objectName = new ObjectName(objectNameString + ",*");
        }
        return objectName;
    }

    public void setDispatcherServerGroup(DispatcherServerGroup dispatcherServerGroup) {
        this.dispatcherServerGroup = dispatcherServerGroup;
    }

    public MBeanList getMBeanList() {
        MBeanList list = new MBeanList();
        list.addAll(this.getMBeans());
        return list;
    }

    public Collection<String> getServerGroups() {
        return this.dispatcherServerGroup.getServerGroups();
    }

    public JMXDispatcherList getDispatchersForGroup(String serverGroup) {
        return this.dispatcherServerGroup.getDispatchersForGroup(serverGroup);
    }

    public void updateGroups() {
        ArrayList<DynamicMBean> beanList = new ArrayList<DynamicMBean>(this.getMBeans());
        for (DynamicMBean mBean : beanList) {
            if (!(mBean instanceof UpdateGroupsInterface)) continue;
            UpdateGroupsInterface updateMBean = (UpdateGroupsInterface)((Object)mBean);
            updateMBean.updateGroups(this);
        }
    }

    public void registerMBean(ObjectName objectName, DynamicMBean mBean) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.getProxyServer().registerMBean(mBean, objectName);
        this.put(objectName, mBean);
        cat.debug("registered mbean " + objectName);
    }

    public boolean isRegistered(ObjectName obj) {
        return this.getProxyServer().isRegistered(obj);
    }

    public void removeMbeansWithPattern(ObjectName typePattern) {
        MBeanRepository repository = this.getPattern(typePattern);
        for (ObjectName objectName : repository.getObjectNames()) {
            this.unregisterMBean(objectName);
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        this.remove(objectName);
        try {
            this.getProxyServer().unregisterMBean(objectName);
            if (cat.isDebugEnabled()) {
                cat.debug("Unregistered MBean " + objectName.toString());
            }
        }
        catch (JMException e) {
            cat.debug("Unable to unregister " + objectName.toString(), (Throwable)e);
        }
    }

    public MBeanRepository createFilteredRepository(MBeanRepositoryFilter filter) {
        MBeanRepository filteredRepository = new MBeanRepository();
        this.addFilteredToRepository(filteredRepository, filter);
        return filteredRepository;
    }

    private synchronized void addFilteredToRepository(MBeanRepository filteredRepository, MBeanRepositoryFilter filter) {
        Iterator<Map.Entry<ObjectName, DynamicMBean>> iterator = this.iterator();
        while (iterator.hasNext()) {
            DynamicMBean mBean;
            Map.Entry<ObjectName, DynamicMBean> repositoryEntry = iterator.next();
            ObjectName objectName = repositoryEntry.getKey();
            if (!filter.matches(objectName, mBean = repositoryEntry.getValue())) continue;
            filteredRepository.put(objectName, mBean);
        }
    }
}

