/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DSServiceAccessSession;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.util.Collections;
import java.util.HashSet;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PogoJMXAuthenticator
implements JMXAuthenticator {
    private static final String PRINCIPAL = "IBM Cognos10";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoJMXAuthenticator.class.getName());
    private static ICCLConfiguration cclconfig = CCLConfigurationFactory.getInstance();

    @Override
    public Subject authenticate(Object credentials) {
        try {
            byte[] shared = (byte[])credentials;
            DSServiceAccessSession session = new DSServiceAccessSession();
            String password = cclconfig.getValue("disp_sharedsecret", false);
            if (session.verifyToken(password.getBytes(), shared)) {
                HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
                principals.add(new JMXPrincipal(PRINCIPAL));
                return new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
            }
        }
        catch (CAMCryptoException e) {
            cat.error("CAM Crypto error: ", (Throwable)e);
        }
        catch (CCLConfigurationException e) {
            cat.error("Cannot get dispatcher shared secret", (Throwable)e);
        }
        throw new SecurityException();
    }
}

