/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServerJMX;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServerNoJMX;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class PogoMBeanServer {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoMBeanServer.class.getName());
    static final String JMX_DOMAIN_PROP = "JMX.domain";
    static final String JMX_DOMAIN_DEFAULT = "com.cognos";
    protected static final Long DEFAULT_SERVER_CONNECTION_TIMEOUT = new Long(60000L);
    private static PogoMBeanServer instance;
    protected MBeanServer server;

    protected PogoMBeanServer() {
    }

    public static synchronized PogoMBeanServer getInstance() {
        if (instance == null) {
            if (PogoMBeanServer.isNoJMX()) {
                instance = new PogoMBeanServerNoJMX();
                cat.debug("Running with No JMX");
            } else {
                instance = new PogoMBeanServerJMX();
                cat.debug("Running with JMX");
            }
            instance.createMBeanServer();
        }
        return instance;
    }

    public static boolean isNoJMX() {
        try {
            Class.forName("mx4j.remote.MX4JRemoteUtils").newInstance();
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Deprecated
    public static ObjectName getObjectName(String serviceName, String metricName) throws MalformedObjectNameException {
        return MBeanUtils.getObjectName(serviceName, metricName);
    }

    @Deprecated
    public static ObjectName getObjectName(String serviceName) throws MalformedObjectNameException {
        return MBeanUtils.getObjectName(serviceName);
    }

    public static String getJmxUrl(boolean sslEnabled, String hostPortContext) {
        return MBeanUtils.getHessianJmxUrl(sslEnabled, hostPortContext);
    }

    public static String getProxyJmxUrl(boolean sslEnabled, String hostPortContext) {
        return MBeanUtils.getProxyHessianJmxUrl(sslEnabled, hostPortContext);
    }

    public static String getJmxUrl(boolean sslEnabled, String hostPortContext, String webapp) {
        return MBeanUtils.getProxyHessianJmxUrl(sslEnabled, hostPortContext);
    }

    public static final String getJmxDomain() {
        String domain = PropertyInserter.getProperty(JMX_DOMAIN_PROP);
        if (domain == null || domain.trim().length() == 0) {
            if (domain != null) {
                cat.warn("Empty domain defined in the properties file; default one is used");
            }
            domain = JMX_DOMAIN_DEFAULT;
        }
        return domain;
    }

    public abstract Long getServerConnectionTimeout();

    public abstract MBeanServer createProxyMBeanServer() throws Exception;

    protected abstract void createMBeanServer();

    public abstract MBeanServer getProxyMBeanServer();

    public abstract void startHessianConnector();

    public abstract void stopServer();

    public MBeanServer getServer() {
        return this.server;
    }

    public void registerMBean(CounterMbeanInterface counter, String serviceName) {
        try {
            this.server.registerMBean(counter, MBeanUtils.createObjectNameInstance("type=" + counter.getName() + ",service=" + serviceName));
        }
        catch (JMException e) {
            cat.info("Exception in register MBean ", (Throwable)e);
        }
    }

    static void resetForTesting() {
        instance = null;
    }

    public abstract void setProxyMBeanServer(MBeanServer var1);

    public void startProxyRMIConnector() {
    }

    public void stopProxyRMIConnector() {
    }

    public void stopProxyConnectors() {
    }

    public void startProxyJMXMPConnector() {
    }

    public void stopProxyJMXMPConnector() {
    }
}

