/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.ProcessMetricsMBean;
import java.util.Date;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ProcessMetrics
extends MetricNotificationSupport
implements ProcessMetricsMBean,
CounterMbeanInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor("METRICS." + ProcessMetrics.class.getName());
    private final String name;
    private Date lastResetTime = new Date();
    private long numberOfProcesses = 0L;
    private Date numberOfProcessesLastUpdateTime = new Date();
    private long numberOfProcessesHighWaterMark = 0L;
    private Date numberOfProcessesHighWaterMarkLastUpdateTime = new Date();
    private long numberOfProcessesLowWaterMark = Long.MAX_VALUE;
    private Date numberOfProcessesLowWaterMarkLastUpdateTime = new Date();
    private long numberOfConfiguredProcesses = 0L;
    private Date numberOfConfiguredProcessesLastUpdateTime = new Date();
    private long numberOfUnexpectedAbortedProcesses = 0L;
    private long numberOfHungProcesses = 0L;
    private final String service;

    public ProcessMetrics(String name, String service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public void reset() {
        if (cat.isDebugEnabled()) {
            cat.debug("reset queue service=" + this.service);
        }
        this.sendAttributeChangedNotification("NumberOfProcessesHighWaterMark", this.numberOfProcessesHighWaterMark, 0L);
        this.sendAttributeChangedNotification("NumberOfProcessesLowWaterMark", this.numberOfProcessesLowWaterMark, Long.MAX_VALUE);
        this.numberOfProcessesHighWaterMark = 0L;
        this.setNumberOfProcessesHighWaterMarkLastUpdateTime();
        this.numberOfProcessesLowWaterMark = Long.MAX_VALUE;
        this.setNumberOfProcessesLowWaterMarkLastUpdateTime();
        this.numberOfUnexpectedAbortedProcesses = 0L;
        this.numberOfHungProcesses = 0L;
        this.setLastResetTime();
    }

    @Override
    public Date getLastProcessResetTime() {
        return this.lastResetTime;
    }

    @Override
    public long getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    @Override
    public Date getNumberOfProcessesLastUpdateTime() {
        return this.numberOfProcessesLastUpdateTime;
    }

    @Override
    public long getNumberOfProcessesHighWaterMark() {
        return this.numberOfProcessesHighWaterMark;
    }

    @Override
    public Date getNumberOfProcessesHighWaterMarkLastUpdateTime() {
        return this.numberOfProcessesHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getNumberOfProcessesLowWaterMark() {
        if (this.numberOfProcessesLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.numberOfProcessesLowWaterMark;
    }

    @Override
    public Date getNumberOfProcessesLowWaterMarkLastUpdateTime() {
        return this.numberOfProcessesLowWaterMarkLastUpdateTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setNumberOfProcesses(long numberOfProcesses) {
        if (cat.isDebugEnabled()) {
            cat.debug("Processes service=" + this.service + " number=" + numberOfProcesses);
        }
        long oldNumber = this.numberOfProcesses;
        this.numberOfProcesses = numberOfProcesses;
        this.setNumberOfProcessesLastUpdateTime();
        if (numberOfProcesses > this.numberOfProcessesHighWaterMark) {
            long oldHigh = this.numberOfProcessesHighWaterMark;
            this.numberOfProcessesHighWaterMark = numberOfProcesses;
            this.setNumberOfProcessesHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("NumberOfProcessesHighWaterMark", oldHigh, this.numberOfProcessesHighWaterMark);
        }
        if (numberOfProcesses < this.numberOfProcessesLowWaterMark) {
            long oldLow = this.numberOfProcessesLowWaterMark;
            this.numberOfProcessesLowWaterMark = numberOfProcesses;
            this.setNumberOfProcessesLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("NumberOfProcessesLowWaterMark", oldLow, this.numberOfProcessesLowWaterMark);
        }
        this.sendAttributeChangedNotification("NumberOfProcesses", oldNumber, numberOfProcesses);
    }

    private void setLastResetTime() {
        this.lastResetTime.setTime(System.currentTimeMillis());
    }

    private void setNumberOfProcessesHighWaterMarkLastUpdateTime() {
        this.numberOfProcessesHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setNumberOfProcessesLastUpdateTime() {
        this.numberOfProcessesLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setNumberOfProcessesLowWaterMarkLastUpdateTime() {
        this.numberOfProcessesLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    @Override
    public long getNumberOfConfiguredProcesses() {
        return this.numberOfConfiguredProcesses;
    }

    public void setNumberOfConfiguredProcesses(long numberOfProcesses) {
        long oldNumber = this.numberOfConfiguredProcesses;
        this.numberOfConfiguredProcesses = numberOfProcesses;
        this.setNumberOfConfiguredProcessesLastUpdateTime();
        this.sendAttributeChangedNotification("NumberOfConfiguredProcesses", oldNumber, this.numberOfConfiguredProcesses);
    }

    private void setNumberOfConfiguredProcessesLastUpdateTime() {
        this.numberOfConfiguredProcessesLastUpdateTime.setTime(System.currentTimeMillis());
    }

    @Override
    public Date getNumberOfConfiguredProcessesLastUpdateTime() {
        return this.numberOfConfiguredProcessesLastUpdateTime;
    }

    @Override
    public long getNumberOfUnexpectedAbortedProcesses() {
        return this.numberOfUnexpectedAbortedProcesses;
    }

    public void incrementNumberOfUnexpectedAbortedProcesses() {
        ++this.numberOfUnexpectedAbortedProcesses;
    }

    @Override
    public long getNumberOfHungProcesses() {
        return this.numberOfHungProcesses;
    }

    public void incrementNumberOfHungProcesses() {
        ++this.numberOfHungProcesses;
    }
}

