/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.monitoring.jmx.DispatcherProxyUpdater;
import com.cognos.pogo.monitoring.jmx.DispatcherServerGroup;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherList;
import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.proxy.ProxyCreation;
import com.cognos.pogo.monitoring.jmx.proxy.ServerGroupCreation;
import com.cognos.pogo.monitoring.jmx.report.ProxyInteractiveReportMonitor;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedHealthMBeanCollection;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedThresholdManager;
import com.cognos.pogo.monitoring.jmx.threshold.ProxyThresholdManager;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ProxyMBeanManager {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final String DISPATCHER_PROXY_UPDATER = "com.cognos:type=DispatcherProxyUpdater";
    private ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection;
    private ServerGroupCreation serverGroupCreator;
    protected ProxyCreation proxyCreator;
    private MBeanRepository mBeanRepository;
    private JMXDispatcherList completeDispatcherList;

    public ProxyMBeanManager() {
        this(new MBeanRepository());
    }

    public ProxyMBeanManager(MBeanRepository beanRepository) {
        this.mBeanRepository = beanRepository;
    }

    MBeanRepository getMBeanRepository() {
        return this.mBeanRepository;
    }

    public void createProxies(ArrayList<String> proxyList, ConsolidatedThresholdManager thresholdManager, DispatcherList dispatcherList) {
        this.constructProxies(proxyList, thresholdManager);
        this.initializeProxies(dispatcherList, thresholdManager);
        this.registerDispatcherProxyUpdater();
    }

    protected void setProxyCreator(ArrayList<String> proxyList) {
        this.proxyCreator = new ProxyCreation(this.mBeanRepository, proxyList);
    }

    private void constructProxies(ArrayList<String> proxyList, ConsolidatedThresholdManager thresholdManager) {
        this.setProxyCreator(proxyList);
        this.consolidatedHealthMBeanCollection = new ConsolidatedHealthMBeanCollection(this.mBeanRepository, thresholdManager);
        this.serverGroupCreator = new ServerGroupCreation(this.mBeanRepository, this.consolidatedHealthMBeanCollection);
    }

    private void initializeProxies(DispatcherList dispatcherList, ConsolidatedThresholdManager thresholdManager) {
        this.completeDispatcherList = new JMXDispatcherList(dispatcherList);
        this.proxyCreator.createProxyMBeans(this.completeDispatcherList);
        this.setupDispatcherServerGroups(dispatcherList);
        this.serverGroupCreator.createProxyGroupMBeans();
        this.consolidatedHealthMBeanCollection.createHealthMBeans();
        this.createProxyThresholdManager(thresholdManager);
        this.createProxyInteractiveReportMonitor();
        this.setupDispatcherAvailability();
    }

    protected void setupDispatcherServerGroups(DispatcherList dispatcherList) {
        DispatcherServerGroup dispatcherServerGroups = this.createGroup(dispatcherList);
        this.mBeanRepository.setDispatcherServerGroup(dispatcherServerGroups);
    }

    public void resetDispatcherList(DispatcherList newDispatcherList) {
        this.completeDispatcherList = this.updateDispatcherList(this.completeDispatcherList, newDispatcherList);
        DispatcherServerGroup newDispatcherServerGroups = this.createGroup(newDispatcherList);
        this.mBeanRepository.setDispatcherServerGroup(newDispatcherServerGroups);
        this.serverGroupCreator.syncServerGroups(newDispatcherServerGroups);
        this.mBeanRepository.updateGroups();
    }

    private JMXDispatcherList updateDispatcherList(JMXDispatcherList completeDispatcherList2, DispatcherList newDispatcherList) {
        JMXDispatcherList currentJmxDispatcherList = completeDispatcherList2;
        JMXDispatcherList newJmxDispatcherList = new JMXDispatcherList(newDispatcherList);
        currentJmxDispatcherList.update(newJmxDispatcherList);
        JMXDispatcherList removed = currentJmxDispatcherList.getRemoved();
        this.proxyCreator.removeProxyMBeans(removed);
        this.disconnectDispatchers(removed);
        this.proxyCreator.createProxyMBeans(currentJmxDispatcherList);
        return currentJmxDispatcherList;
    }

    DispatcherServerGroup createGroup(DispatcherList list) {
        DispatcherServerGroup group = new DispatcherServerGroup(list);
        group.checkDispatcherAvailability();
        return group;
    }

    private void disconnectDispatchers(JMXDispatcherList oldDispatchers) {
        for (JMXDispatcher jmxDispatcher : oldDispatchers.values()) {
            jmxDispatcher.disconnect();
            cat.debug("Disconnecting dispatcher " + jmxDispatcher.getName());
        }
    }

    private void createProxyThresholdManager(ConsolidatedThresholdManager consolidatedThresholdManager) {
        try {
            MBeanServer mbeanServer = PogoMBeanServer.getInstance().getServer();
            MBeanInfo beanInfo = mbeanServer.getMBeanInfo(MBeanUtils.createObjectNameInstance("type=ThresholdManager"));
            ProxyThresholdManager proxyThresholdManager = new ProxyThresholdManager(this.mBeanRepository, beanInfo, consolidatedThresholdManager);
            this.mBeanRepository.registerMBean(MBeanUtils.createObjectNameInstance("type=ThresholdManager"), proxyThresholdManager);
        }
        catch (JMException e) {
            cat.error("Exception creating proxy threshold manager", e);
        }
    }

    void createProxyInteractiveReportMonitor() {
        try {
            DynamicMBean monitorMBean = this.mBeanRepository.getAny(MBeanUtils.createObjectNameInstance("type=ReportServerInteractiveRequests,*"));
            if (monitorMBean != null) {
                ProxyInteractiveReportMonitor proxyInteractiveReportMonitor = new ProxyInteractiveReportMonitor(this.mBeanRepository);
                this.mBeanRepository.registerMBean(MBeanUtils.createObjectNameInstance("type=ReportServerInteractiveRequests"), proxyInteractiveReportMonitor);
            }
        }
        catch (JMException e) {
            cat.error("Exception creating proxy interactive report monitor", e);
        }
    }

    protected void setupDispatcherAvailability() {
        for (JMXDispatcher jmxDispatcher : this.getDispatchers()) {
            if (!jmxDispatcher.canConnect()) {
                jmxDispatcher.setAvailable(false);
                continue;
            }
            jmxDispatcher.setAvailable(true);
        }
    }

    public Collection<JMXDispatcher> getDispatchers() {
        return this.completeDispatcherList.values();
    }

    public void checkDispatcherAvailability() {
        for (JMXDispatcher jmxDispatcher : this.getDispatchers()) {
            try {
                if (!jmxDispatcher.canConnect()) {
                    jmxDispatcher.setAvailable(false);
                    continue;
                }
                jmxDispatcher.setAvailable(true);
            }
            catch (Exception e) {
                jmxDispatcher.setAvailable(false);
                cat.info("Exception while checking dispatcher availability, " + jmxDispatcher.getName(), e);
            }
        }
    }

    void makeDispatcherAvailable(String dispatcherName) {
        this.proxyCreator.createProxiesForDispatcher(dispatcherName, this.completeDispatcherList, true);
    }

    void setDispatcherUnavailable(String dispatcherName) {
        this.proxyCreator.createProxiesForDispatcher(dispatcherName, this.completeDispatcherList, false);
        this.mBeanRepository.updateGroups();
    }

    public void removeAllConnections() {
        for (JMXDispatcher jmxDispatcher : this.getDispatchers()) {
            cat.debug("removeAllConnections() - disconnect '" + jmxDispatcher.getJmxUrl() + "'.");
            jmxDispatcher.disconnect();
        }
    }

    public boolean haveProxiesChanged() {
        return this.proxyCreator == null ? false : this.proxyCreator.areProxiesRecreated();
    }

    private void registerDispatcherProxyUpdater() {
        DispatcherProxyUpdater dispatcherProxyUpdater = new DispatcherProxyUpdater(this);
        MBeanServer mBeanServer = PogoMBeanServer.getInstance().getProxyMBeanServer();
        try {
            mBeanServer.registerMBean(dispatcherProxyUpdater, ObjectName.getInstance(DISPATCHER_PROXY_UPDATER));
        }
        catch (JMException e) {
            cat.error("Unable to register dispatcher proxy updater", e);
        }
    }
}

