/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import java.util.Collections;
import java.util.HashSet;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;

public class SingleUserPasswordAuthenticator
implements JMXAuthenticator {
    private static final String BAD_CREDENTIALS = "Bad credentials";
    private final String user;
    private final String pass;

    public SingleUserPasswordAuthenticator(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    public SingleUserPasswordAuthenticator(String[] credentials) {
        this.user = credentials[0];
        this.pass = credentials[1];
    }

    @Override
    public Subject authenticate(Object credentials) {
        this.validateCredentials(credentials);
        HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
        principals.add(new JMXPrincipal(this.user));
        return new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    void validateCredentials(Object credentials) throws SecurityException {
        if (credentials == null) {
            this.validateNullCredentials();
        } else if (credentials instanceof String[]) {
            this.validateCredentials((String[])credentials);
        } else {
            throw new SecurityException(BAD_CREDENTIALS);
        }
    }

    private void validateNullCredentials() throws SecurityException {
        if (!this.user.equals("") || !this.pass.equals("")) {
            throw new SecurityException(BAD_CREDENTIALS);
        }
    }

    private void validateCredentials(String[] credentials) throws SecurityException {
        if (!this.user.equals(this.getUser(credentials))) {
            throw new SecurityException(BAD_CREDENTIALS);
        }
        if (!this.pass.equals(this.getPassword(credentials))) {
            throw new SecurityException(BAD_CREDENTIALS);
        }
    }

    private String getUser(String[] credentials) {
        return this.getCredential(credentials, 0);
    }

    private String getPassword(String[] credentials) {
        return this.getCredential(credentials, 1);
    }

    private String getCredential(String[] credentials, int index) {
        return credentials.length > index ? credentials[index] : null;
    }
}

