/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.aggregator;

import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.AverageAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.DateAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.HealthAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.HighWaterAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.LastAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.LastResponseTimeAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.LowWaterAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.OperationalStatusAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.SumAttributeAggregator;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;

public class AttributeAggregatorFactory {
    private HashMap<String, MBeanAttributeInfo> attributeMap = new HashMap();

    public AttributeAggregatorFactory(MBeanAttributeInfo[] attributeInfos) {
        for (int i = 0; i < attributeInfos.length; ++i) {
            MBeanAttributeInfo info = attributeInfos[i];
            this.attributeMap.put(info.getName(), info);
        }
    }

    public AttributeAggregator createAttributeAggregator(String attributeName) throws AttributeNotFoundException {
        MBeanAttributeInfo beanAttributeInfo = this.attributeMap.get(attributeName);
        if (beanAttributeInfo == null) {
            throw new AttributeNotFoundException(attributeName);
        }
        return this.createAttributeAggregator(beanAttributeInfo);
    }

    private AttributeAggregator createAttributeAggregator(MBeanAttributeInfo attributeInfo) {
        if (attributeInfo.getName().equals("Uptime")) {
            return new HighWaterAttributeAggregator();
        }
        if (attributeInfo.getName().equals("QueueLengthHighWaterMark")) {
            return new SumAttributeAggregator();
        }
        if (attributeInfo.getName().equals("QueueLengthLowWaterMark")) {
            return new SumAttributeAggregator();
        }
        if (attributeInfo.getName().equals("NumberOfProcessesHighWaterMark")) {
            return new SumAttributeAggregator();
        }
        if (attributeInfo.getName().equals("NumberOfProcessesLowWaterMark")) {
            return new SumAttributeAggregator();
        }
        if (attributeInfo.getName().equals("ConsolidatedLastResponseTime")) {
            return new LastResponseTimeAttributeAggregator();
        }
        if (attributeInfo.getName().equals("NumberOfSessions")) {
            return new HighWaterAttributeAggregator();
        }
        if (attributeInfo.getName().equals("NumberOfSessionsHighWaterMark")) {
            return new HighWaterAttributeAggregator();
        }
        if (attributeInfo.getName().equals("NumberOfSessionsLowWaterMark")) {
            return new HighWaterAttributeAggregator();
        }
        if (attributeInfo.getName().startsWith("Global")) {
            return new LastAttributeAggregator();
        }
        if (attributeInfo.getName().startsWith("TimeInGlobal")) {
            return new LastAttributeAggregator();
        }
        if (attributeInfo.getName().startsWith("NumberOfGlobal")) {
            return new LastAttributeAggregator();
        }
        if (attributeInfo.getName().endsWith("Health")) {
            return new HealthAttributeAggregator();
        }
        if (attributeInfo.getName().endsWith("HighWaterMark")) {
            return new HighWaterAttributeAggregator();
        }
        if (attributeInfo.getName().endsWith("LowWaterMark")) {
            return new LowWaterAttributeAggregator();
        }
        if (attributeInfo.getName().endsWith("OperationalStatus")) {
            return new OperationalStatusAttributeAggregator();
        }
        if (attributeInfo.getName().endsWith("Percent")) {
            return new AverageAttributeAggregator();
        }
        if (attributeInfo.getType().equals("java.util.Date")) {
            return new DateAttributeAggregator();
        }
        if (attributeInfo.getType().equals("long")) {
            return new SumAttributeAggregator();
        }
        return new LastAttributeAggregator();
    }
}

