/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.aggregator;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.HealthAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.proxy.DispatcherServiceAttributeConsolidator;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherServiceHealthConsolidator
extends DispatcherServiceAttributeConsolidator {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherServiceHealthConsolidator.class.getName());
    private DynamicMBean[] groupHealthMBean;

    public DispatcherServiceHealthConsolidator(MBeanRepository mBeanRepository, String mBeanType, String group) {
        super(mBeanRepository, mBeanType, group);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.equals("Health")) {
            String[] attributes = new String[]{"*"};
            AttributeList attributeList = super.getAttributes(attributes);
            Object health = this.consolidatedHealth(attributeList);
            return health;
        }
        return super.getAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = super.getAttributes(attributes);
        Object health = this.consolidatedHealth(attributeList);
        attributeList.add(new Attribute("Health", health));
        return attributeList;
    }

    @Override
    protected void addOptionalAttributes(ArrayList<String> dispatcherServiceList) {
        dispatcherServiceList.add("Health");
    }

    private Object consolidatedHealth(AttributeList attributeList) {
        HealthAttributeAggregator aggregator = new HealthAttributeAggregator();
        for (Attribute attribute : attributeList) {
            try {
                aggregator.combine(attribute.getValue());
            }
            catch (Exception exception) {}
        }
        for (int i = 0; i < this.groupHealthMBean.length; ++i) {
            this.aggregateHealthAt(aggregator, i);
        }
        return aggregator.getAggregation();
    }

    private void aggregateHealthAt(AttributeAggregator aggregator, int i) {
        try {
            Object groupHealth = this.groupHealthMBean[i].getAttribute("Health");
            aggregator.combine(groupHealth);
        }
        catch (JMException e) {
            cat.debug("Group health not found: ", (Throwable)e);
        }
    }

    @Override
    public void updateGroups(MBeanRepository mBeanRepository) {
        super.updateGroups(mBeanRepository);
        try {
            ObjectName dispatcherObjectName = MBeanUtils.createObjectNameInstance("type=Metrics,group=" + this.group + ",*");
            this.groupHealthMBean = mBeanRepository.getPattern(dispatcherObjectName).getMBeanList().getMBeanArray();
        }
        catch (MalformedObjectNameException e) {
            cat.debug("Should never happen:", (Throwable)e);
        }
    }
}

