/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.calculate;

import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class Calculation {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(Calculation.class.getName());
    private final String attributeName;
    protected final String attribute1;
    protected final String attribute2;
    protected final ConcreteMBean consolidator;

    public Calculation(ConcreteMBean consolidator2, String attributeName, String attribute1, String attribute2) {
        this.consolidator = consolidator2;
        this.attributeName = attributeName;
        this.attribute1 = attribute1;
        this.attribute2 = attribute2;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getReturnType() {
        return Long.TYPE.getName();
    }

    public boolean attributesAreIn(HashSet<String> attributeNameSet) {
        return attributeNameSet.contains(this.attribute1) && attributeNameSet.contains(this.attribute2);
    }

    public boolean attributesAreIn(HashMap<String, Set<Calculation>> attributeMap) {
        return attributeMap.containsKey(this.attribute1) && attributeMap.containsKey(this.attribute2);
    }

    public Object execute() {
        try {
            Long l1 = (Long)this.consolidator.getAttribute(this.attribute1);
            Long l2 = (Long)this.consolidator.getAttribute(this.attribute2);
            long l1v = l1;
            long l2v = l2;
            return this.doCalculation(l1v, l2v);
        }
        catch (JMException e) {
            cat.info("Exception in calculation of " + this.getAttributeName(), (Throwable)e);
            return null;
        }
    }

    protected abstract Object doCalculation(long var1, long var3);
}

