/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpConsoleOutputter;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpMBean;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpOutputter;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpSimpleXMLOutputter;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumper;
import java.io.IOException;
import java.util.Date;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanDump
implements MBeanDumpMBean {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDump.class.getName());
    private static final String DEFAULT_OUTPUTTER = "simplexml";
    private String filename;
    private MBeanDumper mbeanDumper = new MBeanDumper();
    private long maxFilesize;
    private String outputterName;
    private MBeanDumpOutputter outputter;
    private long rolloverLimit = 0L;
    private Date lastDumpTime;
    private String lastDumpStatus;
    private boolean resetAfterDump = false;

    public MBeanDump() {
        this.setOutputter(DEFAULT_OUTPUTTER);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String newFilename) {
        if (this.filename == null || !this.filename.equals(newFilename)) {
            this.filename = newFilename;
            this.outputter.setFilename(this.filename);
        }
    }

    @Override
    public long getMaxFilesize() {
        return this.maxFilesize;
    }

    @Override
    public void setMaxFilesize(long filesize) {
        this.maxFilesize = filesize;
    }

    @Override
    public String[] getMBeanNames() {
        return this.mbeanDumper.getMbeanNames();
    }

    @Override
    public void setMBeanNames(String[] names) {
        this.mbeanDumper.setMbeanNames(names);
    }

    @Override
    public long getRolloverLimit() {
        return this.rolloverLimit;
    }

    @Override
    public void setRolloverLimit(long rolloverLimit) {
        this.rolloverLimit = rolloverLimit;
    }

    @Override
    public long getIteration() {
        return this.mbeanDumper.getIteration();
    }

    @Override
    public void dump() {
        try {
            this.outputter.checkRollover(this.maxFilesize, this.rolloverLimit);
            this.mbeanDumper.dump(this.resetAfterDump);
            this.lastDumpTime = new Date();
            this.lastDumpStatus = "good";
        }
        catch (JMException e) {
            cat.debug("MBeanDump JMException", (Throwable)e);
            this.lastDumpStatus = "failed: JMException";
        }
        catch (IOException e) {
            cat.debug("MBeanDump IOException", (Throwable)e);
            this.lastDumpStatus = "failed: IOException";
        }
    }

    @Override
    public String getOutputter() {
        return this.outputterName;
    }

    @Override
    public void setOutputter(String outputterName) {
        this.outputterName = outputterName;
        if (outputterName.equalsIgnoreCase("console")) {
            this.outputter = new MBeanDumpConsoleOutputter();
        } else if (outputterName.equalsIgnoreCase(DEFAULT_OUTPUTTER)) {
            this.outputter = new MBeanDumpSimpleXMLOutputter();
        }
        if (this.filename != null) {
            this.outputter.setFilename(this.filename);
        }
        this.mbeanDumper.setOutputter(this.outputter);
    }

    public void setConnection(MBeanServerConnection connection) {
        this.mbeanDumper.setConnection(connection);
    }

    public void stop() throws IOException {
        this.mbeanDumper.terminate();
    }

    @Override
    public Date getLastDumpTime() {
        return this.lastDumpTime;
    }

    @Override
    public String getLastDumpStatus() {
        return this.lastDumpStatus;
    }

    @Override
    public boolean getResetAfterDump() {
        return this.resetAfterDump;
    }

    @Override
    public void setResetAfterDump(boolean reset) {
        this.resetAfterDump = reset;
    }
}

