/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.dump.ConfigFileWatcher;
import com.cognos.pogo.monitoring.jmx.dump.MBeanConfigurationChangeInterface;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpConfig;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpControl;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import java.io.FileNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentException;

public class MBeanDumpControlHandler
extends BasicHandler
implements MBeanConfigurationChangeInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDumpControlHandler.class.getName());
    private static final String DUMP_ENABLED_ADVANCED_SETTING = "DISP.MetricDumpEnabled";
    private String configFileName;
    private MBeanDumpControl mbeanDumpControl;
    private boolean currentEnabled = false;

    public MBeanDumpControlHandler() {
        super(cat);
    }

    @Override
    public void start() {
        this.mbeanDumpControl = new MBeanDumpControl();
        this.mbeanDumpControl.setEnabled(this.currentEnabled);
        MBeanServer server = PogoMBeanServer.getInstance().getServer();
        try {
            server.registerMBean(this.mbeanDumpControl, MBeanUtils.createObjectNameInstance("type=MBeanDumpControl"));
        }
        catch (JMException e) {
            cat.warn("Ignored exception registering MBeanDumpControl MBean");
        }
        String filename = PropertyInserter.getProperty("mbeandump.filename");
        this.configFileName = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/" + filename);
        String checkIntervalStr = PropertyInserter.getProperty("mbeandump.checkInterval");
        long checkInterval = Long.parseLong(checkIntervalStr);
        if (cat.isDebugEnabled()) {
            cat.debug("Using config file: " + this.configFileName);
            cat.debug("Dump config file check interval = " + checkInterval);
        }
        ConfigFileWatcher watcher = new ConfigFileWatcher();
        watcher.startWatchingConfigFile(checkInterval, this.configFileName, this);
    }

    @Override
    public void configurationChange() {
        MBeanDumpConfig mBeanDumpConfig = new MBeanDumpConfig();
        try {
            mBeanDumpConfig.read(this.configFileName);
            this.mbeanDumpControl.reconfigure(mBeanDumpConfig);
            this.mbeanDumpControl.setEnabled(this.currentEnabled);
        }
        catch (FileNotFoundException e) {
            this.configFileNotFound();
        }
        catch (DocumentException e) {
            cat.error("Unable to parse MBeanDump config file", (Throwable)e);
        }
    }

    private void configFileNotFound() {
        cat.debug("MBeanDump config file not found");
        this.mbeanDumpControl.setEnabled(false);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    @Override
    public void configure(Configuration configuration) {
        boolean newenabled;
        String enabledDispatcher = configuration.getValue(DUMP_ENABLED_ADVANCED_SETTING);
        if (this.mbeanDumpControl != null) {
            this.mbeanDumpControl.setEnabledDispatcher(enabledDispatcher);
        }
        if (enabledDispatcher == null) {
            return;
        }
        NodeID nodeID = NodeID.getNodeID(enabledDispatcher);
        boolean bl = newenabled = nodeID != null && nodeID.isLocalToSelf();
        if (this.currentEnabled != newenabled) {
            this.currentEnabled = newenabled;
            if (this.mbeanDumpControl != null) {
                this.mbeanDumpControl.setEnabled(this.currentEnabled);
            }
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }
}

