/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.p2pd.util.DOMWriter;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpOutputter;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;

public class MBeanDumpSimpleXMLOutputter
extends MBeanDumpOutputter {
    private boolean atBeginning;
    private String dispatcherName = PropertyInserter.getProperty("dispatcher.name");

    @Override
    public void putMBean(ObjectName objectName) throws IOException {
        if (!this.atBeginning) {
            this.writeMBeanEnd();
        }
        this.writer.write("<mbean name=\"");
        this.writer.write(DOMWriter.normalize(objectName.toString(), false));
        this.writer.write("\">\n\t<attributes>\n");
        this.atBeginning = false;
    }

    private void writeMBeanEnd() throws IOException {
        this.writer.write("\t</attributes>\n</mbean>\n");
    }

    @Override
    public void putAttribute(Attribute attribute) throws IOException {
        this.writer.write("\t\t<attribute name=\"");
        this.writer.write(attribute.getName());
        this.writer.write("\">\n\t\t\t<value>\n\t\t\t\t");
        this.stringify(attribute.getValue());
        this.writer.write("\n\t\t\t</value>\n\t\t</attribute>\n");
    }

    private void stringify(Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof CompositeData) {
            CompositeData composite = (CompositeData)value;
            CompositeType type = composite.getCompositeType();
            Set<String> keySet = type.keySet();
            String[] itemNames = keySet.toArray(new String[keySet.size()]);
            Object[] all = composite.getAll(itemNames);
            this.writer.write("<composite>\n");
            for (int i = 0; i < all.length; ++i) {
                this.writer.write("<attribute name =\"");
                this.writer.write(itemNames[i]);
                this.writer.write("\">\n<value>\n");
                this.stringify(all[i]);
                this.writer.write("\n</value>\n</attribute>\n");
            }
            this.writer.write("</composite>\n");
        } else {
            this.writer.write(value.toString());
        }
    }

    @Override
    public void beginDump() throws IOException {
        this.writer.write("<dump time=\"");
        Date now = new Date();
        this.writer.write(now.toString());
        this.writer.write("\">\n");
        this.atBeginning = true;
    }

    @Override
    public void endDump() throws IOException {
        this.writeMBeanEnd();
        this.writer.write("</dump>\n");
        this.writer.flush();
    }

    @Override
    public void start() throws IOException {
        this.writer.write("<dumps dispatcher=\"");
        this.writer.write(this.dispatcherName);
        this.writer.write("\">\n");
        this.writer.flush();
    }

    @Override
    public void terminate() throws IOException {
        if (this.writer != null) {
            this.writer.write("</dumps>\n");
            this.writer.flush();
        }
    }
}

