/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpOutputter;
import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanDumper {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDumper.class.getName());
    private String[] mbeanNames;
    private int dumpIteration = 0;
    private MBeanServerConnection connection;
    private MBeanDumpOutputter outputter;
    private boolean started;

    public void dump(boolean reset) throws MalformedObjectNameException, IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.outputter.beginDump();
        for (int b = 0; b < this.mbeanNames.length; ++b) {
            Set<ObjectName> set = this.connection.queryNames(ObjectName.getInstance(this.mbeanNames[b]), null);
            for (ObjectName objectName : set) {
                this.dumpMBean(reset, objectName);
            }
        }
        this.outputter.endDump();
        ++this.dumpIteration;
    }

    private void dumpMBean(boolean reset, ObjectName objectName) throws IOException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.outputter.putMBean(objectName);
        String[] attributes = this.getAttributes(objectName);
        AttributeList attributeValues = this.connection.getAttributes(objectName, attributes);
        for (Attribute attribute : attributeValues) {
            this.outputter.putAttribute(attribute);
        }
        this.doReset(reset, objectName);
    }

    private String[] getAttributes(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo beanInfo = this.connection.getMBeanInfo(objectName);
        MBeanAttributeInfo[] attributeInfo = beanInfo.getAttributes();
        String[] attributes = new String[attributeInfo.length];
        for (int i = 0; i < attributeInfo.length; ++i) {
            String attributeName;
            MBeanAttributeInfo info = attributeInfo[i];
            attributes[i] = attributeName = info.getName();
        }
        return attributes;
    }

    private void doReset(boolean reset, ObjectName objectName) throws InstanceNotFoundException, ReflectionException, IOException {
        if (reset) {
            try {
                this.connection.invoke(objectName, "reset", null, null);
            }
            catch (Exception e) {
                cat.debug("Unable to reset " + objectName, (Throwable)e);
            }
        }
    }

    public void setup() throws IOException {
        this.outputter.start();
        this.started = true;
    }

    public void terminate() throws IOException {
        if (this.started) {
            this.outputter.terminate();
        }
    }

    public String[] getMbeanNames() {
        return this.mbeanNames;
    }

    public void setMbeanNames(String[] mbeanNames) {
        this.mbeanNames = mbeanNames;
    }

    public void setConnection(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public void setOutputter(MBeanDumpOutputter outputter) {
        this.outputter = outputter;
    }

    public long getIteration() {
        return this.dumpIteration;
    }
}

