/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherList;
import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.proxy.UpdateGroupsInterface;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherServiceAttributeConsolidator
implements DynamicMBean,
UpdateGroupsInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherServiceAttributeConsolidator.class.getName());
    private final HashMap<String, DynamicMBean> dispatcherMBeanHashMap = new HashMap();
    private MBeanInfo mBeanInfo;
    protected final String mBeanType;
    protected final String group;

    public DispatcherServiceAttributeConsolidator(MBeanRepository mBeanRepository, String mBeanType, String group) {
        this.mBeanType = mBeanType;
        this.group = group;
        this.updateGroups(mBeanRepository);
    }

    @Override
    public void updateGroups(MBeanRepository mBeanRepository) {
        this.createMBeanInfo(mBeanRepository);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        int commaPos = attribute.indexOf(",");
        String dispatcher = attribute.substring(0, commaPos);
        String service = attribute.substring(commaPos + 1);
        DynamicMBean serviceMBean = this.dispatcherMBeanHashMap.get(dispatcher);
        if (serviceMBean == null) {
            throw new AttributeNotFoundException();
        }
        try {
            return serviceMBean.getAttribute(service);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attrList = new AttributeList();
        HashMap<String, ArrayList<String>> attributeMap = attributes.length == 1 && attributes[0].equals("*") ? this.fullServiceList() : this.decodeAttributes(attributes);
        for (Map.Entry<String, ArrayList<String>> dispatcherEntry : attributeMap.entrySet()) {
            String dispatcher = dispatcherEntry.getKey();
            ArrayList<String> serviceList = dispatcherEntry.getValue();
            DynamicMBean mbean = this.dispatcherMBeanHashMap.get(dispatcher);
            String[] serviceArray = new String[serviceList.size()];
            serviceList.toArray(serviceArray);
            try {
                AttributeList serviceAttributes = mbean.getAttributes(serviceArray);
                this.modifyAttributeList(attrList, dispatcher, serviceAttributes);
            }
            catch (RuntimeException e) {
                cat.info("Error getting mbean attributes", (Throwable)e);
            }
        }
        return attrList;
    }

    private void modifyAttributeList(AttributeList attrList, String dispatcher, AttributeList serviceAttributes) {
        for (Attribute attribute : serviceAttributes) {
            StringBuffer newName = new StringBuffer(dispatcher);
            newName.append(",").append(attribute.getName());
            attrList.add(new Attribute(newName.toString(), attribute.getValue()));
        }
    }

    private HashMap<String, ArrayList<String>> decodeAttributes(String[] attributes) {
        HashMap<String, ArrayList<String>> dispatcherServiceMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            int commaPos = attribute.indexOf(",");
            if (commaPos == -1) continue;
            String dispatcher = attribute.substring(0, commaPos);
            String service = attribute.substring(commaPos + 1);
            ArrayList<String> serviceList = dispatcherServiceMap.get(dispatcher);
            if (serviceList == null) {
                serviceList = new ArrayList();
                dispatcherServiceMap.put(dispatcher, serviceList);
            }
            serviceList.add(service);
        }
        return dispatcherServiceMap;
    }

    private HashMap<String, ArrayList<String>> fullServiceList() {
        HashMap<String, ArrayList<String>> fullList = new HashMap<String, ArrayList<String>>();
        for (String dispatcher : this.dispatcherMBeanHashMap.keySet()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("*");
            fullList.put(dispatcher, list);
        }
        return fullList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    private void createMBeanInfo(MBeanRepository mBeanRepository) {
        ArrayList<String> dispatcherServiceList = this.createDispatcherServiceList(mBeanRepository);
        this.addOptionalAttributes(dispatcherServiceList);
        MBeanAttributeInfo[] attrInfo = this.createAttributeInfo(dispatcherServiceList);
        this.mBeanInfo = new MBeanInfo(this.getClass().getName(), "description", attrInfo, null, null, null);
    }

    ArrayList<String> createDispatcherServiceList(MBeanRepository mBeanRepository) {
        ArrayList<String> dispatcherServiceList = new ArrayList<String>();
        this.dispatcherMBeanHashMap.clear();
        JMXDispatcherList dispatchers = mBeanRepository.getDispatchersForGroup(this.group);
        Iterator<JMXDispatcher> iter = dispatchers.completeIterator();
        while (iter.hasNext()) {
            JMXDispatcher dispatcher = iter.next();
            DynamicMBean bean = this.getDispatcherMBean(mBeanRepository, dispatcher);
            if (bean == null) continue;
            this.dispatcherMBeanHashMap.put(dispatcher.getName(), bean);
            this.getMBeanAttributes(dispatcherServiceList, dispatcher, bean);
        }
        return dispatcherServiceList;
    }

    DynamicMBean getDispatcherMBean(MBeanRepository mBeanRepository, JMXDispatcher dispatcher) {
        try {
            ObjectName dispatcherObjectName = MBeanUtils.createObjectNameInstance("type=" + this.mBeanType + ",dispatcher=\"" + dispatcher.getName() + "\"");
            return mBeanRepository.get(dispatcherObjectName);
        }
        catch (MalformedObjectNameException e) {
            cat.error("Unexpected exception: ", (Throwable)e);
            return null;
        }
    }

    private void getMBeanAttributes(ArrayList<String> dispatcherServiceList, JMXDispatcher dispatcher, DynamicMBean bean) {
        try {
            MBeanAttributeInfo[] attributes = bean.getMBeanInfo().getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                MBeanAttributeInfo info = attributes[i];
                String infoName = info.getName();
                StringBuffer attrBuffer = new StringBuffer(dispatcher.getName());
                attrBuffer.append(",");
                attrBuffer.append(infoName);
                dispatcherServiceList.add(attrBuffer.toString());
            }
        }
        catch (JMRuntimeException e) {
            cat.debug("Exception on getting mbean info ", (Throwable)e);
        }
    }

    private MBeanAttributeInfo[] createAttributeInfo(ArrayList<String> dispatcherServiceList) {
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[dispatcherServiceList.size()];
        int infoIndex = 0;
        for (String attrName : dispatcherServiceList) {
            attrInfo[infoIndex++] = new MBeanAttributeInfo(attrName, "java.lang.String", attrName, true, false, false);
        }
        return attrInfo;
    }

    protected void addOptionalAttributes(ArrayList<String> dispatcherServiceList) {
    }

    HashMap<String, DynamicMBean> getDispatcherMBeanHashMapForTesting() {
        return this.dispatcherMBeanHashMap;
    }
}

