/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheWithIsolatedAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MBeanCacheWithCMAttributes
extends MBeanCacheWithIsolatedAttributes {
    private ArrayList<String> cmAttributes = null;
    private static boolean isActiveCM;
    private static MBeanServerConnection cmMbeanServer;
    protected static HashMap<String, HashMap<String, Object>> cmCache;
    protected static long cmCacheLastUpdateInMillis;

    protected MBeanCacheWithCMAttributes(DynamicMBean aBean) throws MBeanException {
        super(aBean);
    }

    public void registerCMAttribute(String attributeName) {
        if (this.cmAttributes == null) {
            this.cmAttributes = new ArrayList(1);
        }
        if (!this.cmAttributes.contains(attributeName)) {
            this.cmAttributes.add(attributeName);
            if (cat.isDebugEnabled()) {
                cat.debug(this + ".registerCMAttribute(" + attributeName + "): bean " + this.getObjectName());
            }
        }
    }

    @Override
    protected AttributeList retrieveCacheableAttributes(String attributeName) throws MBeanException {
        if (this.cmAttributes != null && this.cmAttributes.contains(attributeName) && cmMbeanServer != null) {
            ObjectName objectNameToUse;
            String[] attributes = new String[this.cmAttributes.size()];
            this.cmAttributes.toArray(attributes);
            if (cat.isDebugEnabled()) {
                cat.debug(this + ".validateCache(" + attributeName + "): retrieving attributes from the CM, object name = " + this.getObjectName());
            }
            if ((objectNameToUse = this.getObjectName()) != null) {
                Hashtable<String, String> propList = objectNameToUse.getKeyPropertyList();
                propList.remove("dispatcher");
                try {
                    objectNameToUse = new ObjectName(objectNameToUse.getDomain(), propList);
                    if (cat.isDebugEnabled()) {
                        cat.debug(this + ".validateCache(" + attributeName + "): object name changed from " + this.getObjectName() + " to " + objectNameToUse);
                    }
                }
                catch (Exception e) {
                    cat.debug(this + ".validateCache(" + attributeName + "): Exception while adjusting object name = " + objectNameToUse, e);
                }
            }
            try {
                String objectNameString = objectNameToUse.toString();
                AttributeList attributeList = this.getCMAttributes(objectNameString, attributes);
                if (attributeList == null) {
                    attributeList = cmMbeanServer.getAttributes(objectNameToUse, attributes);
                    this.setCMAttributes(objectNameString, attributes, attributeList);
                }
                return attributeList;
            }
            catch (Exception e) {
                if (cat.isDebugEnabled()) {
                    cat.debug(this + ".validateCache(" + attributeName + "): Exception thrown while getting attribute from CM MBean Server, object name = " + objectNameToUse, e);
                }
                throw new MBeanException(e, e.toString() + " thrown while getting attribute from CM MBean Server");
            }
        }
        return super.retrieveCacheableAttributes(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeList getCMAttributes(String objectNameString, String[] attributes) {
        if (cat.isDebugEnabled()) {
            cat.debug(this + ".getCMAttributes(" + objectNameString + ")");
        }
        HashMap<String, HashMap<String, Object>> hashMap = cmCache;
        synchronized (hashMap) {
            if (this.getCurrentTime() - cmCacheLastUpdateInMillis > cacheExpiryInMillis) {
                cat.debug("CM cache is stale, cleaning up");
                cmCache.clear();
                return null;
            }
            return this.getCMAttributesFromCache(objectNameString, attributes);
        }
    }

    protected AttributeList getCMAttributesFromCache(String objectNameString, String[] attributes) {
        AttributeList attrList = null;
        HashMap<String, Object> objectNameAttributes = cmCache.get(objectNameString);
        if (objectNameAttributes != null) {
            attrList = new AttributeList();
            for (int i = 0; i < attributes.length; ++i) {
                String attrName = attributes[i];
                Object attrValue = objectNameAttributes.get(attrName);
                if (attrValue == null) continue;
                attrList.add(new Attribute(attrName, attrValue));
                if (!cat.isDebugEnabled()) continue;
                cat.debug("Attribute retrieved from the CM cache: objectName=" + objectNameString + ", attrName=" + attrName + ", attrValue=" + attrValue);
            }
        }
        return attrList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCMAttributes(String objectNameString, String[] attributes, AttributeList attrList) {
        if (cat.isDebugEnabled()) {
            cat.debug(this + ".setCMAttributes(" + objectNameString + ")");
        }
        HashMap<String, HashMap<String, Object>> hashMap = cmCache;
        synchronized (hashMap) {
            HashMap<String, Object> objectNameAttributes = cmCache.get(objectNameString);
            if (objectNameAttributes == null) {
                objectNameAttributes = new HashMap();
                cmCache.put(objectNameString, objectNameAttributes);
            }
            for (Attribute attribute : attrList) {
                objectNameAttributes.put(attribute.getName(), attribute.getValue());
                if (!cat.isDebugEnabled()) continue;
                cat.debug("Attribute stored in the CM cache: objectName=" + objectNameString + ", attrName=" + attribute.getName() + ", attrValue=" + attribute.getValue());
            }
            cmCacheLastUpdateInMillis = this.getCurrentTime();
        }
    }

    public static void setActiveJMXDispatcher(JMXDispatcher activeJMXDispatcher) {
        cmMbeanServer = activeJMXDispatcher.getMbeanServerConnection();
        isActiveCM = activeJMXDispatcher.isLocalActiveCM();
        if (cat.isDebugEnabled()) {
            cat.debug("MBeanCache.setActiveJMXDispatcher(): New cmMbeanServer = " + cmMbeanServer + ", isActiveCM = " + isActiveCM);
        }
    }

    static {
        cmCache = new HashMap();
        cmCacheLastUpdateInMillis = 0L;
    }
}

