/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.proxy.MBeanCache;
import java.util.HashSet;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanException;

public abstract class MBeanCacheWithIsolatedAttributes
extends MBeanCache {
    private HashSet<String> isolatedAttributes = null;

    protected MBeanCacheWithIsolatedAttributes(DynamicMBean aBean) throws MBeanException {
        super(aBean);
    }

    public void registerAttributeForIsolatedCaching(String attributeName) {
        if (this.isolatedAttributes == null) {
            this.isolatedAttributes = new HashSet();
        }
        if (!this.isolatedAttributes.contains(attributeName)) {
            this.isolatedAttributes.add(attributeName);
            if (cat.isDebugEnabled()) {
                cat.debug(this + ".registerAttributeForIsolatedCaching(" + attributeName + "): bean " + this.getObjectName());
            }
        }
    }

    @Override
    protected AttributeList retrieveCacheableAttributes(String attributeName) throws MBeanException {
        if (this.isolatedAttributes != null && this.isolatedAttributes.contains(attributeName)) {
            String[] attributes = new String[this.isolatedAttributes.size()];
            this.isolatedAttributes.toArray(attributes);
            if (cat.isDebugEnabled()) {
                cat.debug(this + ".validateCache(" + attributeName + "): isolated attribute, no read-ahead caching. Object name = " + this.getObjectName());
            }
            return this.getBean().getAttributes(attributes);
        }
        return super.retrieveCacheableAttributes(attributeName);
    }
}

