/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.calculate.ConcreteMBean;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanConsolidator
extends NotificationBroadcasterSupport
implements NotifyingDynamicMBean,
NotificationEmitter,
NotificationListener,
ConcreteMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanConsolidator.class.getName());
    protected ObjectName[] beanList;
    private MBeanInfo mBeanInfo = null;
    protected MBeanServer mBeanServer;
    private HashMap<String, ObjectName> attributeToBeanMap = new HashMap();

    public MBeanConsolidator(MBeanServer mBeanServer, ObjectName[] names) {
        this.mBeanServer = mBeanServer;
        this.beanList = names;
        this.registerNotifications();
        this.initializeAttributeMap();
    }

    private void initializeAttributeMap() {
        for (ObjectName bean : this.beanList) {
            MBeanInfo beanInfo = this.getBeanInfo(bean);
            if (beanInfo == null) continue;
            for (MBeanAttributeInfo mBeanAttributeInfo : beanInfo.getAttributes()) {
                String attributeName = mBeanAttributeInfo.getName();
                if (this.attributeToBeanMap.containsKey(attributeName)) continue;
                this.attributeToBeanMap.put(attributeName, bean);
            }
        }
    }

    private void registerNotifications() {
        for (ObjectName name : this.beanList) {
            try {
                this.mBeanServer.addNotificationListener(name, this, null, null);
            }
            catch (InstanceNotFoundException e) {
                cat.warn("Unable to find MBean named " + name, (Throwable)e);
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        Object returnValue = null;
        ObjectName bean = this.getBeanFromAttribute(attribute);
        try {
            returnValue = this.mBeanServer.getAttribute(bean, attribute);
        }
        catch (JMException e) {
            this.throwAttributeNotFoundException(attribute, e);
        }
        return returnValue;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        String attributeName = attribute.getName();
        ObjectName bean = this.getBeanFromAttribute(attributeName);
        try {
            this.mBeanServer.setAttribute(bean, attribute);
        }
        catch (JMException e) {
            this.throwAttributeNotFoundException(attributeName, e);
        }
    }

    private ObjectName getBeanFromAttribute(String attribute) throws AttributeNotFoundException {
        ObjectName bean = this.attributeToBeanMap.get(attribute);
        if (bean == null) {
            this.throwAttributeNotFoundException(attribute, null);
        }
        return bean;
    }

    private void throwAttributeNotFoundException(String attribute, JMException e) throws AttributeNotFoundException {
        AttributeNotFoundException ex = new AttributeNotFoundException(attribute);
        if (e != null) {
            ex.initCause(e);
        }
        throw ex;
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attrList = new AttributeList();
        for (ObjectName bean : this.beanList) {
            try {
                AttributeList attributes2 = this.mBeanServer.getAttributes(bean, attributes);
                this.addUnique(attrList, attributes2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return attrList;
    }

    private void addUnique(AttributeList attrList, AttributeList attributes2) {
        attrList.removeAll(attributes2);
        attrList.addAll(attributes2);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList attrList = new AttributeList();
        for (ObjectName bean : this.beanList) {
            try {
                attrList.addAll(this.mBeanServer.setAttributes(bean, attributes));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return attrList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object returned = null;
        for (ObjectName bean : this.beanList) {
            try {
                if (this.hasOneElement(params) && actionName.equals("reset")) {
                    String type = bean.getKeyProperty("type");
                    if (!params[0].equals(type)) continue;
                    returned = this.mBeanServer.invoke(bean, actionName, null, null);
                    continue;
                }
                returned = this.mBeanServer.invoke(bean, actionName, params, signature);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return returned;
    }

    private boolean hasOneElement(Object[] params) {
        return params != null && params.length == 1;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            this.mBeanInfo = this.getAllMBeanInfo();
        }
        return this.mBeanInfo;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getMBeanInfo().getNotifications();
    }

    private MBeanInfo getAllMBeanInfo() {
        HashSet<MBeanFeatureInfo> attrList = new HashSet<MBeanFeatureInfo>();
        ArrayList<MBeanConstructorInfo> constrList = new ArrayList<MBeanConstructorInfo>();
        HashSet<MBeanFeatureInfo> opList = new HashSet<MBeanFeatureInfo>();
        ArrayList<MBeanNotificationInfo> notifList = new ArrayList<MBeanNotificationInfo>();
        for (ObjectName bean : this.beanList) {
            MBeanInfo beanInfo = this.getBeanInfo(bean);
            if (beanInfo == null) continue;
            this.mergeAttributes(attrList, beanInfo.getAttributes());
            constrList.addAll(Arrays.asList(beanInfo.getConstructors()));
            this.mergeAttributes(opList, beanInfo.getOperations());
            notifList.addAll(Arrays.asList(beanInfo.getNotifications()));
        }
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attrList.size()];
        attrList.toArray(attrInfo);
        MBeanConstructorInfo[] constrInfo = new MBeanConstructorInfo[constrList.size()];
        constrList.toArray(constrInfo);
        MBeanParameterInfo[] signature = new MBeanParameterInfo[]{new MBeanParameterInfo("type", "java.lang.String", " type")};
        opList.add(new MBeanOperationInfo("reset", "reset", signature, "void", 1));
        MBeanOperationInfo[] operations = new MBeanOperationInfo[opList.size()];
        opList.toArray(operations);
        MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[notifList.size()];
        notifList.toArray(notifInfo);
        return new MBeanInfo(this.getClass().getName(), "description", attrInfo, constrInfo, operations, notifInfo);
    }

    private MBeanInfo getBeanInfo(ObjectName bean) {
        MBeanInfo beanInfo = null;
        try {
            beanInfo = this.mBeanServer.getMBeanInfo(bean);
        }
        catch (InstanceNotFoundException e) {
            cat.warn("MBean not found", (Throwable)e);
        }
        catch (IntrospectionException e) {
            cat.warn("Introspection error", (Throwable)e);
        }
        catch (ReflectionException e) {
            cat.warn("Reflection error", (Throwable)e);
        }
        return beanInfo;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.sendNotification(notification);
    }

    private void mergeAttributes(HashSet<MBeanFeatureInfo> attrList, MBeanFeatureInfo[] attributes) {
        for (MBeanFeatureInfo attrInfo : attributes) {
            attrList.add(attrInfo);
        }
    }
}

