/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherList;
import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.UnavailableOperationalStatusMBean;
import com.cognos.pogo.monitoring.jmx.proxy.PogoRemoteMBeanProxy;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ProxyCreation {
    static final PogoLogger cat = PogoLogger.getLogger();
    private MBeanRepository proxyMBeanList;
    private final ArrayList<String> proxyList;
    private boolean bProxiesAreRecreated = false;

    public ProxyCreation(MBeanRepository beanRepository, ArrayList<String> proxyList) {
        this.proxyMBeanList = beanRepository;
        this.proxyList = proxyList;
        this.bProxiesAreRecreated = false;
    }

    private MBeanServer getProxyServer() {
        return PogoMBeanServer.getInstance().getProxyMBeanServer();
    }

    public void createProxyMBeans(JMXDispatcherList allDispatchers) {
        this.setProxiesRecreated(false);
        for (JMXDispatcher jmxDispatcher : allDispatchers.values()) {
            this.recreateProxiesForDispatcher(jmxDispatcher);
        }
    }

    public void removeProxyMBeans(JMXDispatcherList allDispatchers) {
        for (JMXDispatcher jmxDispatcher : allDispatchers.values()) {
            this.removeDispatcherProxyMBeans(jmxDispatcher);
        }
    }

    private void recreateProxiesForDispatcher(JMXDispatcher dispatcher) {
        boolean available = dispatcher.isAvailable();
        this.createProxiesForDispatcher(dispatcher, available);
    }

    private void setProxiesRecreated(boolean bRecreated) {
        this.bProxiesAreRecreated = bRecreated;
    }

    public boolean areProxiesRecreated() {
        return this.bProxiesAreRecreated;
    }

    protected void createProxiesForDispatcher(JMXDispatcher dispatcher, boolean available) {
        if (this.changedAvailability(dispatcher, available)) {
            this.setProxiesRecreated(true);
            this.removeDispatcherProxyMBeans(dispatcher);
            if (available && dispatcher.canConnect()) {
                if (cat.isInfoEnabled()) {
                    cat.info("Dispatcher " + dispatcher.getName() + " is Available");
                }
                this.createProxiesForDispatcher(dispatcher);
            } else {
                if (cat.isInfoEnabled()) {
                    cat.info("Dispatcher " + dispatcher.getName() + " is Unavailable");
                }
                this.createUnavailableProxyForDispatcher(dispatcher);
            }
        }
    }

    boolean changedAvailability(JMXDispatcher dispatcher, boolean available) {
        boolean wasAvailable = true;
        try {
            ObjectName objectNameForDispatcher = this.getObjectNameForDispatcher(dispatcher, "Metrics");
            ObjectInstance objectInstance = this.getProxyServer().getObjectInstance(objectNameForDispatcher);
            if (objectInstance == null) {
                return true;
            }
            cat.debug("Object instance name= ", objectInstance.getClassName());
            if (objectInstance.getClassName().equals("com.cognos.pogo.monitoring.jmx.UnavailableOperationalStatusMBean")) {
                wasAvailable = false;
            }
        }
        catch (Exception e) {
            cat.debug("Exception finding dispatcher: ", e);
            return true;
        }
        return available != wasAvailable;
    }

    public void createProxiesForDispatcher(String dispatcherName, JMXDispatcherList completeDispatcherList, boolean available) {
        cat.debug("creating proxies for dispatcher: ", dispatcherName, " available: ", available);
        this.setProxiesRecreated(false);
        JMXDispatcher jmxDispatcher = completeDispatcherList.getDispatcher(dispatcherName);
        if (jmxDispatcher != null) {
            jmxDispatcher.setAvailable(available);
            this.createProxiesForDispatcher(jmxDispatcher, available);
        }
    }

    private void createUnavailableProxyForDispatcher(JMXDispatcher dispatcher) {
        UnavailableOperationalStatusMBean mbean = new UnavailableOperationalStatusMBean();
        try {
            this.createUnavailableMBean(dispatcher, "Metrics", mbean);
            this.createUnavailableMBean(dispatcher, "ServiceOperationalStatus", mbean);
        }
        catch (MalformedObjectNameException e) {
            cat.info("caught MalformedObjectNameException", e);
        }
        catch (JMException e) {
            cat.info("Error registering unavailable dispatcher MBean", e);
        }
    }

    private void createUnavailableMBean(JMXDispatcher dispatcher, String type, UnavailableOperationalStatusMBean mbean) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName proxyName = this.getObjectNameForDispatcher(dispatcher, type);
        this.proxyMBeanList.registerMBean(proxyName, mbean);
    }

    private ObjectName getObjectNameForDispatcher(JMXDispatcher dispatcher, String type) throws MalformedObjectNameException {
        return MBeanUtils.createObjectNameInstance("type=" + type + ",dispatcher=\"" + dispatcher.getName() + "\"");
    }

    void createProxiesForDispatcher(JMXDispatcher jmxDispatcher) {
        try {
            MBeanServerConnection mbeanServerConnection = jmxDispatcher.getMbeanServerConnection();
            if (mbeanServerConnection != null) {
                for (String proxyMBeanName : this.proxyList) {
                    this.getProxiesForType(jmxDispatcher, proxyMBeanName, jmxDispatcher.getName());
                }
            }
        }
        catch (MalformedURLException e) {
            cat.info("URLException while connecting to server" + jmxDispatcher.getJmxUrl(), e);
        }
        catch (IOException e) {
            cat.info("IOException while connecting to server" + jmxDispatcher.getJmxUrl(), e);
        }
    }

    private void getProxiesForType(JMXDispatcher jmxDispatcher, String proxyMBeanName, String dispatcherName) throws IOException {
        try {
            MBeanServerConnection connection = jmxDispatcher.getMbeanServerConnection();
            Set<ObjectName> objectNameList = connection.queryNames(ObjectName.getInstance(proxyMBeanName), null);
            for (ObjectName objectName : objectNameList) {
                this.createMBeanProxy(jmxDispatcher, objectName, dispatcherName);
            }
        }
        catch (JMException e) {
            cat.info("JMX exception while getting an MBean of type=" + proxyMBeanName, e);
        }
    }

    private void createMBeanProxy(JMXDispatcher jmxDispatcher, ObjectName remoteObjectName, String dispatcherName) {
        PogoRemoteMBeanProxy proxy = new PogoRemoteMBeanProxy(remoteObjectName, jmxDispatcher);
        try {
            ObjectName proxyName = MBeanUtils.addDispatcherName(remoteObjectName, dispatcherName);
            this.proxyMBeanList.registerMBean(proxyName, (DynamicMBean)((Object)proxy));
            if (cat.isInfoEnabled()) {
                cat.info("Added proxy MBean for " + remoteObjectName + " at " + proxyName);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            cat.warn("JMX exception while creating a proxy MBean for " + remoteObjectName, e);
        }
        catch (JMException e) {
            cat.info("JMX exception while creating a proxy MBean for " + remoteObjectName, e);
        }
    }

    public void removeDispatcherProxyMBeans(JMXDispatcher dispatcher) {
        for (String proxyMBeanName : this.proxyList) {
            this.removeProxiesForType(proxyMBeanName, dispatcher.getName());
        }
    }

    private void removeProxiesForType(String proxyMBeanName, String dispatcherName) {
        if (cat.isDebugEnabled()) {
            cat.debug("removing MBeans for mbean = " + proxyMBeanName + " dispatcher = " + dispatcherName);
        }
        try {
            ObjectName typePattern = ObjectName.getInstance(proxyMBeanName + ",dispatcher=" + ObjectName.quote(dispatcherName));
            this.proxyMBeanList.removeMbeansWithPattern(typePattern);
        }
        catch (MalformedObjectNameException e) {
            cat.warn("Unexpected ObjectName exception", e);
        }
    }
}

