/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.DispatcherServerGroup;
import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.proxy.ServerGroupMBeanCollection;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedHealthMBeanCollection;
import java.util.HashMap;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServerGroupCreation {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServerGroupCreation.class.getName());
    private MBeanRepository mBeanRepository;
    HashMap<String, ServerGroupMBeanCollection> groupCollection = new HashMap();
    private ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection;

    public ServerGroupCreation(MBeanRepository beanRepository, ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection) {
        this.mBeanRepository = beanRepository;
        this.consolidatedHealthMBeanCollection = consolidatedHealthMBeanCollection;
    }

    public void createProxyGroupMBeans() {
        for (String serverGroup : this.mBeanRepository.getServerGroups()) {
            this.createServerGroups(serverGroup);
        }
    }

    private void createServerGroups(String group) {
        String quotedGroup = this.quoteIfNeeded(group);
        ServerGroupMBeanCollection collection = new ServerGroupMBeanCollection(quotedGroup, this.mBeanRepository);
        this.groupCollection.put(group, collection);
        collection.setConsolidatedHealthMBeanCollection(this.consolidatedHealthMBeanCollection);
        collection.createGroupMBeans();
    }

    private String quoteIfNeeded(String group) {
        return this.containsReservedCharacter(group) ? ObjectName.quote(group) : group;
    }

    private boolean containsReservedCharacter(String group) {
        return group.matches(".*(:|,|=|\\*|\\?|\\n|\\\\|\\\").*");
    }

    public void syncServerGroups(DispatcherServerGroup newDispatcherServerGroups) {
        HashMap<String, ServerGroupMBeanCollection> groupCollectionCopy = new HashMap<String, ServerGroupMBeanCollection>(this.groupCollection);
        this.groupCollection.clear();
        Set<String> serverGroups = newDispatcherServerGroups.getServerGroups();
        for (String group : serverGroups) {
            if (!groupCollectionCopy.containsKey(group)) {
                this.createServerGroups(group);
                continue;
            }
            this.moveGroupCollection(groupCollectionCopy, group);
        }
        this.removeUnwantedGroups(groupCollectionCopy);
    }

    private void moveGroupCollection(HashMap<String, ServerGroupMBeanCollection> groupCollectionCopy, String group) {
        ServerGroupMBeanCollection collection = groupCollectionCopy.get(group);
        collection.syncServices();
        this.groupCollection.put(group, collection);
        groupCollectionCopy.remove(group);
    }

    private void removeUnwantedGroups(HashMap<String, ServerGroupMBeanCollection> groupCollectionCopy) {
        for (ServerGroupMBeanCollection collection : groupCollectionCopy.values()) {
            collection.removeGroup();
        }
    }
}

