/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.aggregator.DispatcherServiceHealthConsolidator;
import com.cognos.pogo.monitoring.jmx.aggregator.DispatcherServiceStatusConsolidator;
import com.cognos.pogo.monitoring.jmx.calculate.CalculateMetricsDecorator;
import com.cognos.pogo.monitoring.jmx.proxy.GroupMBeanTotal;
import com.cognos.pogo.monitoring.jmx.proxy.ServerGroupServices;
import com.cognos.pogo.monitoring.jmx.proxy.SystemHealthAddIn;
import com.cognos.pogo.monitoring.jmx.threshold.ConsolidatedHealthMBeanCollection;
import com.cognos.pogo.monitoring.jmx.threshold.MultipleHealthAddIn;
import com.cognos.pogo.monitoring.jmx.threshold.ServiceHealthAddIn;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServerGroupMBeanCollection {
    public static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServerGroupMBeanCollection.class.getName());
    final String groupName;
    public final MBeanRepository mBeanRepository;
    public MBeanServer proxyServer;
    private ServerGroupServices serverGroupService;
    private ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection;

    public ServerGroupMBeanCollection(String group, MBeanRepository beanRepository) {
        this.groupName = group;
        this.mBeanRepository = beanRepository;
        this.proxyServer = PogoMBeanServer.getInstance().getProxyMBeanServer();
        this.serverGroupService = new ServerGroupServices(this.groupName, this.mBeanRepository);
    }

    public void createGroupMBeans() {
        try {
            this.registerGroupMetrics();
            this.registerGroupServiceHealth();
            this.registerAttributeConsolidator();
            this.serverGroupService.registerServices();
        }
        catch (JMException e) {
            cat.error("JMX exception while creating server group MBeans for server group " + this.groupName, (Throwable)e);
        }
    }

    private void registerAttributeConsolidator() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        DispatcherServiceHealthConsolidator attributeConsolidator = new DispatcherServiceHealthConsolidator(this.mBeanRepository, "ServiceHealth", this.groupName);
        ObjectName healthName = MBeanUtils.createObjectNameInstance("type=ConsolidatedServerHealth,group=" + this.groupName);
        this.mBeanRepository.registerMBean(healthName, attributeConsolidator);
        cat.debug("Added group proxy MBean consolidator : " + attributeConsolidator + " at " + healthName);
        DispatcherServiceStatusConsolidator statusAttributeConsolidator = new DispatcherServiceStatusConsolidator(this.mBeanRepository, "ServiceOperationalStatus", this.groupName);
        ObjectName statusName = MBeanUtils.createObjectNameInstance("type=ConsolidatedOperationalStatus,group=" + this.groupName);
        this.mBeanRepository.registerMBean(statusName, statusAttributeConsolidator);
        cat.debug("Added group proxy MBean consolidator : " + statusAttributeConsolidator + " at " + statusName);
    }

    private void registerGroupMetrics() throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName groupObjectName = MBeanUtils.createObjectNameInstance("type=Metrics,group=" + this.groupName);
        ServiceHealthAddIn healthAddIn = this.createHealthAddIn();
        GroupMBeanTotal groupTotalMBean = new GroupMBeanTotal(this.mBeanRepository, groupObjectName, healthAddIn);
        CalculateMetricsDecorator decorator = new CalculateMetricsDecorator(groupTotalMBean);
        this.mBeanRepository.registerMBean(groupObjectName, decorator);
        cat.debug("Added group proxy MBean : " + healthAddIn + " at " + groupObjectName);
        this.createMetricHealth(groupObjectName, decorator);
    }

    private void createMetricHealth(ObjectName groupObjectName, CalculateMetricsDecorator decorator) {
        if (this.consolidatedHealthMBeanCollection != null) {
            this.consolidatedHealthMBeanCollection.createHealthMBean(groupObjectName, decorator);
        } else {
            cat.debug("Unable to register Metric Health MBean for " + groupObjectName);
        }
    }

    private ServiceHealthAddIn createHealthAddIn() throws MalformedObjectNameException {
        MultipleHealthAddIn healthAddIn = this.groupName.equals("System") ? this.createSystemHealthAddIn() : this.createMultipleHealthAddIn(this.groupName);
        healthAddIn.updateGroups(this.mBeanRepository);
        return healthAddIn;
    }

    private MultipleHealthAddIn createMultipleHealthAddIn(String group) throws MalformedObjectNameException {
        ObjectName groupPattern = MBeanUtils.createObjectNameInstance("type=MetricHealth,group=" + group + ",*");
        MultipleHealthAddIn healthAddIn = new MultipleHealthAddIn(this.proxyServer, groupPattern);
        return healthAddIn;
    }

    private MultipleHealthAddIn createSystemHealthAddIn() {
        SystemHealthAddIn healthAddIn = new SystemHealthAddIn();
        return healthAddIn;
    }

    private void registerGroupServiceHealth() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        ObjectName objectName = MBeanUtils.createObjectNameInstance("type=ServiceHealth,group=" + this.groupName);
        GroupMBeanTotal groupServiceHealthMBean = new GroupMBeanTotal(this.mBeanRepository, objectName);
        this.mBeanRepository.registerMBean(objectName, groupServiceHealthMBean);
        cat.debug("Added group proxy MBean : " + groupServiceHealthMBean + " at " + objectName);
    }

    public void syncServices() {
        this.serverGroupService.syncServices();
    }

    public void removeGroup() {
        try {
            ObjectName groupObjectName = MBeanUtils.createObjectNameInstance("group=" + this.groupName + ",*");
            this.mBeanRepository.removeMbeansWithPattern(groupObjectName);
        }
        catch (JMException e) {
            cat.info("Exception removing group " + this.groupName, (Throwable)e);
        }
    }

    public void setConsolidatedHealthMBeanCollection(ConsolidatedHealthMBeanCollection consolidatedHealthMBeanCollection) {
        this.consolidatedHealthMBeanCollection = consolidatedHealthMBeanCollection;
        this.serverGroupService.setConsolidatedHealthMBeanCollection(consolidatedHealthMBeanCollection);
    }
}

