/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.proxy;

import com.cognos.pogo.monitoring.jmx.proxy.MBeanConsolidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SimpleMBeanConsolidator
extends NotificationBroadcasterSupport {
    protected static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanConsolidator.class.getName());
    protected ObjectName[] beanList;
    private MBeanInfo mBeanInfo = null;
    protected MBeanServer mBeanServer;

    public SimpleMBeanConsolidator(MBeanServer mBeanServer, ObjectName[] names) {
        this.mBeanServer = mBeanServer;
        this.beanList = names;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeNotFoundException savedException = null;
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                return this.mBeanServer.getAttribute(this.beanList[i], attribute);
            }
            catch (JMException e) {
                savedException = new AttributeNotFoundException(attribute);
                continue;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeNotFoundException savedException = null;
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                this.mBeanServer.setAttribute(this.beanList[i], attribute);
                return;
            }
            catch (JMException e) {
                savedException = new AttributeNotFoundException();
                continue;
            }
        }
        throw savedException;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                AttributeList attributes2 = this.mBeanServer.getAttributes(this.beanList[i], attributes);
                this.addUnique(attrList, attributes2);
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                continue;
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return attrList;
    }

    private void addUnique(AttributeList attrList, AttributeList attributes2) {
        attrList.removeAll(attributes2);
        attrList.addAll(attributes2);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                attrList.addAll(this.mBeanServer.setAttributes(this.beanList[i], attributes));
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                continue;
            }
            catch (ReflectionException reflectionException) {
                // empty catch block
            }
        }
        return attrList;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object returned = null;
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                if (this.hasOneElement(params) && actionName.equals("reset")) {
                    String type = this.beanList[i].getKeyProperty("type");
                    if (!params[0].equals(type)) continue;
                    returned = this.mBeanServer.invoke(this.beanList[i], actionName, null, null);
                    continue;
                }
                returned = this.mBeanServer.invoke(this.beanList[i], actionName, params, signature);
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return returned;
    }

    private boolean hasOneElement(Object[] params) {
        return params != null && params.length == 1;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            this.mBeanInfo = this.getAllMBeanInfo();
        }
        return this.mBeanInfo;
    }

    private MBeanInfo getAllMBeanInfo() {
        HashSet<MBeanFeatureInfo> attrList = new HashSet<MBeanFeatureInfo>();
        ArrayList<MBeanConstructorInfo> constrList = new ArrayList<MBeanConstructorInfo>();
        HashSet<MBeanFeatureInfo> opList = new HashSet<MBeanFeatureInfo>();
        ArrayList<MBeanNotificationInfo> notifList = new ArrayList<MBeanNotificationInfo>();
        for (int i = 0; i < this.beanList.length; ++i) {
            try {
                MBeanInfo beanInfo = this.mBeanServer.getMBeanInfo(this.beanList[i]);
                this.mergeAttributes(attrList, beanInfo.getAttributes());
                constrList.addAll(Arrays.asList(beanInfo.getConstructors()));
                this.mergeAttributes(opList, beanInfo.getOperations());
                notifList.addAll(Arrays.asList(beanInfo.getNotifications()));
                continue;
            }
            catch (InstanceNotFoundException e) {
                cat.warn("MBean not found", (Throwable)e);
                continue;
            }
            catch (IntrospectionException e) {
                cat.warn("Introspection error", (Throwable)e);
                continue;
            }
            catch (ReflectionException e) {
                cat.warn("Reflection error", (Throwable)e);
            }
        }
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attrList.size()];
        attrList.toArray(attrInfo);
        MBeanConstructorInfo[] constrInfo = new MBeanConstructorInfo[constrList.size()];
        constrList.toArray(constrInfo);
        MBeanParameterInfo[] signature = new MBeanParameterInfo[]{new MBeanParameterInfo("type", "java.lang.String", " type")};
        opList.add(new MBeanOperationInfo("reset", "reset", signature, "void", 1));
        MBeanOperationInfo[] operations = new MBeanOperationInfo[opList.size()];
        opList.toArray(operations);
        MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[notifList.size()];
        notifList.toArray(notifInfo);
        return new MBeanInfo(this.getClass().getName(), "description", attrInfo, constrInfo, operations, notifInfo);
    }

    private void mergeAttributes(HashSet<MBeanFeatureInfo> attrList, MBeanFeatureInfo[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            MBeanFeatureInfo attrInfo = attributes[i];
            attrList.add(attrInfo);
        }
    }
}

