/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.http.httpclient.RawPostMethod;
import com.cognos.pogo.monitoring.jmx.remote.CauchoRawPostMethod;
import com.cognos.pogo.monitoring.jmx.utils.PogoJmxProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.remote.caucho.CauchoInput;
import mx4j.tools.remote.caucho.CauchoOutput;
import mx4j.tools.remote.caucho.hessian.HessianClientInvoker;
import mx4j.tools.remote.http.HTTPConnection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.util.TimeoutController;

public class CognosHessianClientInvoker
extends HessianClientInvoker {
    private static final String CONNECTION_ID_HEADER_NAME = "connectionContext";
    private URL endpointURL;
    private HTTPConnection myService;
    private HttpClient aClient;
    private CAMFactory camFactory;
    private CAMCryptoException lastCryptoException = null;
    private static Logger logger = Log.getLogger((String)CognosHessianClientInvoker.class.getName());
    private int timeout;

    public CognosHessianClientInvoker(String endpoint, Map<String, Object> environment) {
        this(endpoint, environment, PogoJmxProperties.getProxyHessianTimeout());
    }

    public CognosHessianClientInvoker(String endpoint, Map<String, Object> environment, int timeout) {
        super(endpoint);
        this.timeout = timeout;
        try {
            this.endpointURL = new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            this.endpointURL = null;
        }
        MyCauchoServiceProxy proxy = new MyCauchoServiceProxy();
        this.myService = (HTTPConnection)Proxy.newProxyInstance(proxy.getClass().getClassLoader(), new Class[]{HTTPConnection.class}, (InvocationHandler)proxy);
        try {
            this.camFactory = CryptoFacility.getCAMFactory();
            this.aClient = this.camFactory.createHttpClient(this.endpointURL);
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            connectionManager.getParams().setDefaultMaxConnectionsPerHost(20);
            this.aClient.setHttpConnectionManager((HttpConnectionManager)connectionManager);
            Long connectionTimeout = (Long)environment.get("HessianConnectionTimeout");
            if (connectionTimeout != null) {
                connectionManager.getParams().setConnectionTimeout((int)connectionTimeout.longValue());
            }
        }
        catch (CAMCryptoException cryptoException) {
            this.camFactory = null;
            this.aClient = null;
            this.lastCryptoException = cryptoException;
        }
    }

    protected HTTPConnection getService() {
        return this.myService;
    }

    private static String mangleMethodName(Method method) {
        return method.getName() + "__" + method.getParameterTypes().length;
    }

    private class MyCauchoServiceProxy
    implements InvocationHandler {
        protected IOException ioException;

        private MyCauchoServiceProxy() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            CauchoRawPostMethod postMethod = null;
            try {
                if (CognosHessianClientInvoker.this.aClient == null) {
                    throw CognosHessianClientInvoker.this.lastCryptoException;
                }
                postMethod = new CauchoRawPostMethod(CognosHessianClientInvoker.this.endpointURL.getPath());
                postMethod.setRequestBodyGenerator(new BodyGenerator(method, args));
                postMethod.setRequestHeader("connection", "close");
                this.maybeExecuteWithTimeout(postMethod);
                CauchoInput input = CognosHessianClientInvoker.this.createCauchoInput(postMethod.getResponseBodyAsStream());
                input.startReply();
                Object result = input.readObject(null);
                input.completeReply();
                Object object = result;
                return object;
            }
            catch (Exception x) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)"", (Throwable)x);
                }
                throw x;
            }
            finally {
                if (postMethod != null) {
                    if (postMethod.getRequestHeader("connection") == null) {
                        postMethod.setRequestHeader("connection", "close");
                    }
                    postMethod.releaseConnection();
                }
            }
        }

        protected void maybeExecuteWithTimeout(RawPostMethod postMethod) throws Exception {
            if (CognosHessianClientInvoker.this.timeout != 0) {
                this.executeWithTimeout(postMethod);
            } else {
                CognosHessianClientInvoker.this.aClient.executeMethod((HttpMethod)postMethod);
            }
        }

        private void executeWithTimeout(final RawPostMethod postMethod) throws Exception {
            this.ioException = null;
            try {
                TimeoutController.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CognosHessianClientInvoker.this.aClient.executeMethod((HttpMethod)postMethod);
                        }
                        catch (IOException e) {
                            logger.debug((Object)"Exception executing hessian invoke", (Throwable)e);
                            MyCauchoServiceProxy.this.ioException = e;
                        }
                    }
                }, (long)CognosHessianClientInvoker.this.timeout);
            }
            catch (TimeoutController.TimeoutException e) {
                logger.debug((Object)"Exception executing hessian invoke", (Throwable)e);
                throw new IOException("IOException because of timeout ", e);
            }
            if (this.ioException != null) {
                throw this.ioException;
            }
        }

        private void startCall(CauchoOutput output) throws IOException {
            output.startCall();
        }

        private void writeHeaders(CauchoOutput output) throws IOException {
            output.writeHeader(CognosHessianClientInvoker.CONNECTION_ID_HEADER_NAME);
            output.writeObject((Object)CognosHessianClientInvoker.this.getConnectionId());
        }

        private void writeMethod(CauchoOutput output, Method method) throws IOException {
            String methodName = CognosHessianClientInvoker.mangleMethodName(method);
            output.writeMethod(methodName);
        }

        private void writeArguments(CauchoOutput output, Object[] args) throws IOException {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    output.writeObject(args[i]);
                }
            }
        }

        private void completeCall(CauchoOutput output) throws IOException {
            output.completeCall();
        }

        private class BodyGenerator
        implements MsgBodyGenerator {
            private Method myMethod;
            private Object[] myArgs;

            BodyGenerator(Method aMethod, Object[] theArgs) {
                this.myMethod = aMethod;
                this.myArgs = theArgs;
            }

            @Override
            public void writeBody(OutputStream os) throws IOException {
                BufferedOutputStream outputStream = new BufferedOutputStream(os);
                CauchoOutput output = CognosHessianClientInvoker.this.createCauchoOutput(outputStream);
                MyCauchoServiceProxy.this.startCall(output);
                MyCauchoServiceProxy.this.writeHeaders(output);
                MyCauchoServiceProxy.this.writeMethod(output, this.myMethod);
                MyCauchoServiceProxy.this.writeArguments(output, this.myArgs);
                MyCauchoServiceProxy.this.completeCall(output);
                ((OutputStream)outputStream).flush();
            }

            @Override
            public boolean rewind() {
                return false;
            }
        }
    }
}

