/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.CheckProxyResponseException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CheckProxyResponse {
    private static final String PROXY = "proxy";
    private static final String STATUS = "status";
    private static final String JMXURL = "jmxurl";
    private String status;
    private String jmxurl;

    public CheckProxyResponse(Element element) throws CheckProxyResponseException {
        this.status = this.getTextFromElement(element, STATUS);
        this.jmxurl = this.getTextFromElement(element, JMXURL);
    }

    public CheckProxyResponse(String status, String jmxurl) {
        this.status = status;
        this.jmxurl = jmxurl;
    }

    public CheckProxyResponse(String remoteConnectionString) throws DocumentException, CheckProxyResponseException {
        this(DocumentHelper.parseText((String)remoteConnectionString).getRootElement());
    }

    private String getTextFromElement(Element element, String elementName) throws CheckProxyResponseException {
        Element elementForText = element.element(elementName);
        if (elementForText == null) {
            throw new CheckProxyResponseException("Element " + elementName + " missing.");
        }
        return elementForText.getTextTrim();
    }

    public String getStatus() {
        return this.status;
    }

    public String getJmxurl() {
        return this.jmxurl;
    }

    public byte[] getResponse() {
        String rootElement = this.getXmlResponse();
        return rootElement.getBytes();
    }

    String getXmlResponse() {
        Document document = DocumentHelper.createDocument();
        Element remoteDescriptionElement = document.addElement(PROXY);
        remoteDescriptionElement.addElement(JMXURL).addText(this.jmxurl);
        remoteDescriptionElement.addElement(STATUS).addText(this.status);
        String rootElement = document.getRootElement().asXML();
        return rootElement;
    }
}

