/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.monitoring.jmx.remote.proxy.ProxyConfiguration;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.PossibleDispatchers;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPinger;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPingerFactory;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyPingerFactoryImpl;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;

public class ChooseProxy {
    private static PogoLogger log = PogoLogger.getLogger();
    private final PossibleDispatchers possibleDispatchers;
    private String newActiveProxy;
    private boolean updated = false;
    private String currentActiveProxy;
    private ProxyPingerFactory proxyPingerFactory;

    public ChooseProxy(Configuration configuration) {
        this(new PossibleDispatchers(configuration), ProxyConfiguration.getActiveJMXProxyURI(configuration));
    }

    public ChooseProxy(PossibleDispatchers possibleDispatchers, String currentActiveProxy) {
        this(possibleDispatchers, currentActiveProxy, new ProxyPingerFactoryImpl());
    }

    public ChooseProxy(PossibleDispatchers possibleDispatchers, String currentActiveProxy, ProxyPingerFactory proxyPingerFactory) {
        this.possibleDispatchers = possibleDispatchers;
        this.currentActiveProxy = currentActiveProxy;
        this.proxyPingerFactory = proxyPingerFactory;
    }

    public void scanForProxy() {
        if (this.currentIsValid()) {
            this.newActiveProxy = this.currentActiveProxy;
            log.debug("scanForProxy() - Current proxy is valid: ", this.currentActiveProxy);
            return;
        }
        while (this.hasCandidate()) {
            String candidate = this.possibleDispatchers.getCandidate();
            if (this.canConnect(candidate)) {
                if (candidate.equalsIgnoreCase(this.currentActiveProxy)) {
                    this.newActiveProxy = candidate;
                    log.debug("scanForProxy() - The chosen candidate is the current proxy: ", candidate);
                    return;
                }
                this.updated = true;
                this.newActiveProxy = candidate;
                log.debug("scanForProxy() - New active proxy chosen: ", this.newActiveProxy);
                return;
            }
            log.debug("scanForProxy() - Can not connecto to candidate '" + candidate + "', remove it from candidates list.");
            this.possibleDispatchers.ignoreProxy(candidate);
        }
    }

    public boolean currentIsValid() {
        return this.possibleDispatchers.containsCandidateAsPreferred(this.currentActiveProxy);
    }

    private boolean canConnect(String candidate) {
        ProxyPinger proxyPinger = this.proxyPingerFactory.createProxyPinger(candidate);
        return proxyPinger.proxyIsAvailable();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public String getNewActiveProxy() {
        return this.newActiveProxy;
    }

    public boolean hasCandidate() {
        return this.possibleDispatchers.hasCandidate();
    }

    public void ignoreProxy(String proxyToIgnore) {
        this.possibleDispatchers.ignoreProxy(proxyToIgnore);
    }

    public boolean equals(Object o) {
        if (o instanceof ChooseProxy) {
            ChooseProxy otherChooseProxy = (ChooseProxy)o;
            return this.currentActiveProxy == null && otherChooseProxy.currentActiveProxy == null || this.currentActiveProxy.equals(otherChooseProxy.currentActiveProxy) && this.possibleDispatchers.equals(otherChooseProxy.possibleDispatchers);
        }
        return false;
    }
}

