/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.monitoring.jmx.remote.proxy.ProxyConfiguration;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PossibleDispatchers {
    private static PogoLogger log = PogoLogger.getLogger();
    private ArrayList<String> possibleDispatchers;
    private ArrayList<String> userPreferredDispatchers;

    public PossibleDispatchers(DispatcherList dispatcherList, ArrayList<String> userPreferredProxyDispatchers) {
        this.possibleDispatchers = this.scan(dispatcherList, userPreferredProxyDispatchers);
    }

    public PossibleDispatchers(ArrayList<String> possibleDispatchers) {
        this(possibleDispatchers, new ArrayList<String>());
    }

    public PossibleDispatchers(ArrayList<String> possibleDispatchers, ArrayList<String> preferredDispatchers) {
        this.possibleDispatchers = possibleDispatchers;
        this.userPreferredDispatchers = preferredDispatchers;
    }

    public PossibleDispatchers(Configuration configuration) {
        this((DispatcherList)configuration.getDispatcherList(), ProxyConfiguration.getJMXProxyHostDispatchers(configuration));
    }

    private ArrayList<String> scan(DispatcherList dispatcherList, ArrayList<String> userPreferredProxyDispatchers) {
        HashMap<String, DispatcherListElement> candidateDispatchers = this.findDispatcherCandidates(dispatcherList);
        log.debug("scan() - find all dispatcher candidates for proxy server: " + candidateDispatchers.toString());
        return this.buildJMXUrlList(userPreferredProxyDispatchers, candidateDispatchers);
    }

    private HashMap<String, DispatcherListElement> findDispatcherCandidates(DispatcherList dispatcherList) {
        HashMap<String, DispatcherListElement> candidateDispatchers = new HashMap<String, DispatcherListElement>();
        String proxyScanService = ProxyConfiguration.getProxyScanService();
        if (dispatcherList == null) {
            return candidateDispatchers;
        }
        Iterator<DispatcherListElement> it = dispatcherList.getAllDispatcherListElements();
        block0: while (it.hasNext()) {
            DispatcherListElement dle = it.next();
            Iterator<DispatcherListService> itSrvc = dle.iterator();
            while (itSrvc.hasNext()) {
                DispatcherListService srvc = itSrvc.next();
                String serviceName = srvc.getName();
                if (!serviceName.equals(proxyScanService)) continue;
                candidateDispatchers.put(dle.getPath(), dle);
                continue block0;
            }
        }
        this.maybeAddLocalDispatcherAsCandidate(candidateDispatchers, dispatcherList);
        return candidateDispatchers;
    }

    private void maybeAddLocalDispatcherAsCandidate(HashMap<String, DispatcherListElement> candidateDispatchers, DispatcherList dispatcherList) {
        if (candidateDispatchers.isEmpty() && dispatcherList.getAllDispatcherListElements().hasNext()) {
            DispatcherListElement dle = dispatcherList.getLocalDispatcherElement();
            candidateDispatchers.put(dle.getPath(), dle);
        }
    }

    private ArrayList<String> buildJMXUrlList(ArrayList<String> userPreferredProxyDispatchers, HashMap<String, DispatcherListElement> candidateDispatchers) {
        log.debug("buildJMXUrlList() - user prefered list: " + userPreferredProxyDispatchers.toString());
        ArrayList<String> jmxUrlList = new ArrayList<String>();
        for (int i = 0; i < userPreferredProxyDispatchers.size(); ++i) {
            String searchPath = userPreferredProxyDispatchers.get(i);
            DispatcherListElement disp = candidateDispatchers.get(searchPath);
            if (disp == null) continue;
            jmxUrlList.add(this.getProxyUrlForDispatcher(disp));
            candidateDispatchers.remove(searchPath);
        }
        this.userPreferredDispatchers = new ArrayList(jmxUrlList);
        if (!candidateDispatchers.isEmpty()) {
            for (DispatcherListElement dispElem : candidateDispatchers.values()) {
                jmxUrlList.add(this.getProxyUrlForDispatcher(dispElem));
            }
        }
        log.debug("buildJMXUrlList() - final candidates list: " + jmxUrlList.toString());
        log.debug("buildJMXUrlList() - final user preferred list: " + this.userPreferredDispatchers.toString());
        return jmxUrlList;
    }

    private String getProxyUrlForDispatcher(DispatcherListElement dle) {
        return MBeanUtils.getProxyHessianJmxUrl(dle.isSslEnabled(), dle.getName());
    }

    public boolean hasCandidate() {
        return this.possibleDispatchers.size() > 0;
    }

    public String getDispatcherForTesting(int idx) {
        return this.possibleDispatchers == null || this.possibleDispatchers.size() <= idx ? "" : this.possibleDispatchers.get(idx);
    }

    public String getCandidate() {
        return this.hasCandidate() ? this.possibleDispatchers.get(0) : null;
    }

    public boolean containsCandidate(String correctJmxUrl) {
        return this.possibleDispatchers.contains(correctJmxUrl);
    }

    public boolean containsCandidateAsPreferred(String correctJmxUrl) {
        if (this.userPreferredDispatchers.size() > 0) {
            return this.userPreferredDispatchers.indexOf(correctJmxUrl) == 0;
        }
        return this.containsCandidate(correctJmxUrl);
    }

    public void ignoreProxy(String proxyToIgnore) {
        this.possibleDispatchers.remove(proxyToIgnore);
        this.userPreferredDispatchers.remove(proxyToIgnore);
    }

    public boolean equals(Object o) {
        if (o instanceof PossibleDispatchers) {
            PossibleDispatchers other = (PossibleDispatchers)o;
            return this.possibleDispatchers.equals(other.possibleDispatchers) && this.userPreferredDispatchers.equals(other.userPreferredDispatchers);
        }
        return false;
    }
}

