/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.reportservice.ReportServerRequestInformation;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.dom4j.Element;

public class CachedReportData {
    private final String[] shortTypeNames = new String[]{"RequestID", "RequestTime", "RequestTimeDuration", "StartTime", "StartTimeDuration", "ProcessID", "Status", "DispatcherName"};
    private final String[] longTypeNames = new String[]{"RequestID", "RequestTime", "RequestTimeDuration", "StartTime", "StartTimeDuration", "ProcessID", "Status", "DispatcherName", "RequestDefaultName", "UserName", "ObjectClass", "StoreID", "ScreenTip", "UserID", "TenantID"};
    private final String[] shortTypeDescs = new String[]{"RequestID", "RequestTime", "RequestTimeDuration", "StartTime", "StartTimeDuration", "ProcessID", "Status", "DispatcherName"};
    private final String[] longTypeDescs = new String[]{"RequestID", "RequestTime", "RequestTimeDuration", "StartTime", "StartTimeDuration", "ProcessID", "Status", "DispatcherName", "RequestDefaultName", "UserName", "ObjectClass", "StoreID", "ScreenTip", "UserID", "TenantID"};
    private final OpenType<?>[] shortTypeTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING};
    private final OpenType<?>[] longTypeTypes = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    private String dispatcherName;
    private long requestTime;
    private long requestTimeDuration;
    private long startTime;
    private long startTimeDuration;
    private String passportID;
    private int processID;
    private String listType;
    private String requestID;
    private String requestName;
    private Element requestBody;
    private String userName;
    private String objectClass;
    private String storeID;
    private String screenTip;
    private String reportPath;
    private String userID;
    private String tenantID;

    public CachedReportData() {
        this.dispatcherName = PropertyInserter.getProperty("dispatcher.name");
    }

    public CachedReportData(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public void getCachedReportData(ReportServerRequestInformation request, String listType) {
        this.setRequestID(request.getRequestID());
        this.setRequestTime(request.getStartTime());
        this.setStartTime(request.getStartTime());
        this.setProcessID(request.getProcessID());
        this.setPassportID(request.getPassportID());
        this.setReportPath(request.getReportPath());
        this.setRequestBody(request.getRequestBody());
        this.setType(listType);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.startTimeDuration = System.currentTimeMillis() - startTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
        this.requestTimeDuration = System.currentTimeMillis() - requestTime;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public void setType(String listType) {
        this.listType = listType;
    }

    public void setPassportID(String passportID) {
        this.passportID = passportID;
    }

    public String getPassportID() {
        return this.passportID;
    }

    public void setProcessID(int processID) {
        this.processID = processID;
    }

    public int getProcessID() {
        return this.processID;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? "" : userName;
    }

    CompositeData getShortCompositeData() throws OpenDataException {
        CompositeType compositeType = new CompositeType("ReportRequests", "reportRequests", this.shortTypeNames, this.shortTypeDescs, this.shortTypeTypes);
        Object[] values = new Object[this.shortTypeNames.length];
        this.setCommonCompositeData(values);
        CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, this.shortTypeNames, values);
        return compositeData;
    }

    public CompositeData getLongCompositeData() throws OpenDataException {
        CompositeType compositeType = new CompositeType("DetailedReportRequests", "DetailedReportRequests", this.longTypeNames, this.longTypeDescs, this.longTypeTypes);
        Object[] values = new Object[this.longTypeNames.length];
        this.setCommonCompositeData(values);
        values[8] = this.requestName;
        values[9] = this.userName;
        values[10] = this.objectClass;
        values[11] = this.storeID;
        values[12] = this.screenTip;
        values[13] = this.userID;
        values[14] = this.tenantID;
        CompositeDataSupport compositeData = new CompositeDataSupport(compositeType, this.longTypeNames, values);
        return compositeData;
    }

    private void setCommonCompositeData(Object[] values) {
        values[0] = this.requestID;
        values[1] = new Long(this.requestTime);
        values[2] = new Long(this.requestTimeDuration);
        values[3] = new Long(this.startTime);
        values[4] = new Long(this.startTimeDuration);
        values[5] = new Integer(this.processID);
        values[6] = this.listType;
        values[7] = this.dispatcherName;
    }

    public boolean hasDetails() {
        return this.userName != null;
    }

    String getObjectClass() {
        return this.objectClass;
    }

    void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    void setScreenTip(String screenTip) {
        this.screenTip = screenTip;
    }

    void setStoreID(String storeID) {
        this.storeID = storeID;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void setUserID(String userID) {
        this.userID = userID == null ? "" : userID;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public Element getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(Element requestBody) {
        this.requestBody = requestBody;
    }

    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    public String getTenantID() {
        return this.tenantID;
    }
}

