/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.pogo.monitoring.jmx.report.CAMIdentityQuery;
import com.cognos.pogo.monitoring.jmx.report.CachedReportData;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class InteractiveReportCMQuery {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(InteractiveReportCMQuery.class.getName());
    protected ContentManagerMultipleQueryCommand command;
    protected CAMIdentityQuery identityQuery;
    private ArrayList<CachedReportData> queryData = new ArrayList();
    private HashMap<String, Integer> passportMap = new HashMap();
    private HashMap<String, Integer> reportMap = new HashMap();
    private final boolean shown;

    public InteractiveReportCMQuery(String contentLocale, String adminPassportID, boolean shown) {
        this(contentLocale, adminPassportID, shown, new ContentManagerMultipleQueryCommand("/"), new CAMIdentityQuery(adminPassportID));
    }

    public InteractiveReportCMQuery(String contentLocale, String adminPassportID, boolean shown, ContentManagerMultipleQueryCommand accountQueryCommand, CAMIdentityQuery identityQuery) {
        this.shown = shown;
        this.command = accountQueryCommand;
        this.identityQuery = identityQuery;
        BIBusEnvelope requestEnvelope = this.command.getRequestEnvelope();
        requestEnvelope.createCamPassportElement(adminPassportID);
        if (contentLocale != null && !"".equals(contentLocale)) {
            requestEnvelope.setUserPreference("contentLocale", contentLocale);
        }
        this.command.setDoTrustedRequest(true);
    }

    public void reset() {
        this.command.reset();
        this.queryData.clear();
        this.passportMap.clear();
        this.reportMap.clear();
    }

    public void addRequest(CachedReportData data) {
        this.queryData.add(data);
        this.addPassportID(data.getPassportID());
        this.addReportPath(data.getReportPath());
    }

    private void addReportPath(String reportPath) {
        if (reportPath != null && !reportPath.equals("") && !this.reportMap.containsKey(reportPath)) {
            String[] reportProperties = new String[]{"defaultName", "objectClass", "storeID", "screenTip"};
            StringBuffer qualifiedReportPath = new StringBuffer(reportPath);
            qualifiedReportPath.append("[(permission('read') or ");
            qualifiedReportPath.append("permission('write') or ");
            qualifiedReportPath.append("permission('execute') or ");
            qualifiedReportPath.append("permission('setPolicy') or ");
            qualifiedReportPath.append("permission('traverse')) and ");
            qualifiedReportPath.append("@shown='");
            qualifiedReportPath.append(this.shown);
            qualifiedReportPath.append("']");
            int position = this.command.addSearchProperties(qualifiedReportPath.toString(), reportProperties);
            this.reportMap.put(reportPath, new Integer(position));
        }
    }

    private void addPassportID(String passportID) {
        if (!this.passportMap.containsKey(passportID)) {
            String[] passportQueryProperties = new String[]{"defaultName", "userName", "tenantID"};
            int position = this.command.addSearchProperties(this.createPassportIDSearchPath(passportID), passportQueryProperties);
            this.passportMap.put(passportID, new Integer(position));
        }
    }

    public void execute(List<CompositeData> returnList) throws CommandExecutionException {
        List<String> adminReadTenantIDs = this.getAdminReadTenantIDs();
        this.command.execute();
        for (int i = 0; i < this.queryData.size(); ++i) {
            CachedReportData cachedReportData = this.queryData.get(i);
            if (!this.extractReportName(cachedReportData)) continue;
            this.extractUserData(cachedReportData);
            if (!this.canReadRecord(cachedReportData) || !this.canReadRecordTenant(cachedReportData, adminReadTenantIDs)) continue;
            try {
                returnList.add(cachedReportData.getLongCompositeData());
                continue;
            }
            catch (OpenDataException e) {
                cat.error("Exception getting composite data", (Throwable)e);
            }
        }
    }

    private boolean canReadRecord(CachedReportData cachedReportData) {
        return cachedReportData.getTenantID() != null;
    }

    private boolean canReadRecordTenant(CachedReportData cachedReportData, List<String> adminReadTenantIDs) {
        return adminReadTenantIDs == null || adminReadTenantIDs.isEmpty() || adminReadTenantIDs.contains(cachedReportData.getTenantID());
    }

    protected List<String> getAdminReadTenantIDs() throws CommandExecutionException {
        this.identityQuery.execute();
        return this.identityQuery.getTenancy().getReadTenantIDs();
    }

    private String createPassportIDSearchPath(String passportID) {
        StringBuffer buffer = new StringBuffer("passportID('");
        buffer.append(passportID);
        buffer.append("')");
        String searchPath = buffer.toString();
        return searchPath;
    }

    private boolean extractReportName(CachedReportData data) {
        Integer position = this.reportMap.get(data.getReportPath());
        if (position == null) {
            this.extractSpecification(data);
        } else {
            int part = position;
            if (!this.command.hasValue(part)) {
                return false;
            }
            this.extractReportData(data, part);
        }
        return true;
    }

    private void extractReportData(CachedReportData data, int part) {
        Element itemElement;
        String reportName = this.command.getValue(part, "defaultName");
        String objectClass = this.command.getValue(part, "objectClass");
        String storeID = this.command.getValue(part, "storeID");
        String screenTip = null;
        Element valueElement = this.command.getValueElement(part, "screenTip");
        if (valueElement != null && (itemElement = valueElement.element("item")) != null && (valueElement = itemElement.element("value")) != null) {
            screenTip = valueElement.getTextTrim();
        }
        data.setRequestName(reportName);
        data.setObjectClass(objectClass);
        data.setStoreID(storeID);
        data.setScreenTip(screenTip);
    }

    private void extractUserData(CachedReportData data) {
        String passportID = data.getPassportID();
        Integer position = this.passportMap.get(passportID);
        int part = position;
        String userName = this.command.getValue(part, "defaultName");
        String userID = this.command.getValue(part, "userName");
        String tenantID = this.command.getValue(part, "tenantID");
        data.setUserName(userName);
        data.setUserID(userID);
        data.setTenantID(tenantID);
    }

    private void extractSpecification(CachedReportData data) {
        data.setRequestName("");
        data.setObjectClass("specification");
    }

    protected ArrayList<CachedReportData> getQueryData() {
        return this.queryData;
    }
}

