/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class DoubleThresholdComparable
extends ThresholdComparable {
    private final Double value;
    private static final DecimalFormat FORMAT = DoubleThresholdComparable.createFormat();

    public DoubleThresholdComparable(Double doubleValue) {
        this.value = doubleValue;
    }

    public String toString() {
        String formatted = FORMAT.format(this.value);
        return formatted;
    }

    private static DecimalFormat createFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0.######", decimalFormatSymbols);
        return format;
    }

    @Override
    public boolean withinHysteresisRange(ThresholdComparable oldValue) {
        if (!(oldValue instanceof DoubleThresholdComparable)) {
            return false;
        }
        double old = ((DoubleThresholdComparable)oldValue).value;
        double lvalue = this.value;
        double hRange = lvalue * hysteresisRange;
        double high = lvalue + hRange;
        double low = lvalue - hRange;
        return low <= old && old <= high;
    }

    @Override
    public int compareTo(ThresholdComparable otherValue) {
        Comparable<?> comparable = otherValue.getValue();
        if (comparable instanceof Double) {
            return this.value.compareTo((Double)comparable);
        }
        if (comparable instanceof Long) {
            return this.compareValue((Long)comparable);
        }
        return 0;
    }

    @Override
    public Comparable<?> getValue() {
        return this.value;
    }

    public int compareValue(Long other) {
        double anotherVal;
        double thisVal = this.value;
        return thisVal < (anotherVal = other.doubleValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }
}

