/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdAttribute;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdAttributeList;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanHealth
extends MetricNotificationSupport
implements DynamicMBean,
NotificationListener,
NotificationEmitter,
MBeanRegistration {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanHealth.class.getName());
    private final MBeanInfo mBeanInfo;
    protected ThresholdAttributeList thresholdAttributeList = new ThresholdAttributeList();
    private final String serviceName;
    private String servicePath;

    public MBeanHealth(MBeanInfo mBeanInfo, String serviceName) {
        this.mBeanInfo = mBeanInfo;
        this.serviceName = serviceName;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (!this.attributeIsValid(attribute)) {
            throw new AttributeNotFoundException(attribute);
        }
        if (attribute.equals("Health")) {
            return this.consolidatedHealth();
        }
        ThresholdAttribute parameters = this.thresholdAttributeList.get(attribute);
        if (parameters == null) {
            return ThresholdHealth.NOT_APPLICABLE.toString();
        }
        return parameters.getCurrentHealth().toString();
    }

    private boolean attributeIsValid(String attribute) {
        MBeanAttributeInfo[] attributes = this.mBeanInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        int i;
        if (cat.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("mbeanHealth = ");
            msg.append(this.servicePath).append(" attribures = ");
            for (i = 0; i < attributes.length; ++i) {
                msg.append(attributes[i]).append(" ");
            }
            cat.debug(msg.toString());
        }
        AttributeList attrList = new AttributeList();
        for (i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                attrList.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attrList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mBeanInfo.getNotifications();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void addThresholdParameters(String attributeName, ThresholdParameters thresholdParameters) {
        ThresholdAttribute newThresholdAttribute = new ThresholdAttribute(thresholdParameters);
        ThresholdAttribute oldThresholdAttribute = this.thresholdAttributeList.get(attributeName);
        if (oldThresholdAttribute == null || !newThresholdAttribute.equals(oldThresholdAttribute)) {
            this.thresholdAttributeList.put(attributeName, newThresholdAttribute);
        }
    }

    public ThresholdParameters getThresholdParameters(String attributeName) {
        ThresholdAttribute attribute = this.thresholdAttributeList.get(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getParameters();
    }

    public int clearThreshold(String attributeName) {
        ThresholdAttribute thresholdAttribute = this.thresholdAttributeList.get(attributeName);
        if (thresholdAttribute != null) {
            this.thresholdAttributeList.remove(attributeName);
        }
        return this.thresholdAttributeList.size();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        ThresholdAttribute parameters;
        if (!(notification instanceof AttributeChangeNotification)) {
            return;
        }
        AttributeChangeNotification acn = (AttributeChangeNotification)notification;
        String attributeName = acn.getAttributeName();
        if (attributeName.equals("OperationalStatus")) {
            this.fillNotification(acn, null, null);
        }
        if ((parameters = this.thresholdAttributeList.get(attributeName)) == null) {
            return;
        }
        Comparable newValue = (Comparable)acn.getNewValue();
        ThresholdComparable comparable = ThresholdComparable.createThresholdComparable(newValue);
        ThresholdHealth checkResult = parameters.check(comparable);
        if (checkResult != null) {
            this.fillNotification(acn, parameters, checkResult);
        }
    }

    protected void fillNotification(AttributeChangeNotification acn, ThresholdAttribute parameters, ThresholdHealth checkResult) {
        HashMap<String, Object> userData = new HashMap<String, Object>();
        if (checkResult != null) {
            userData.put("health", checkResult);
        }
        userData.put("service", this.serviceName);
        userData.put("path", this.servicePath);
        userData.put("attribute", acn.getAttributeName());
        userData.put("value", acn.getNewValue());
        if (parameters != null) {
            userData.putAll(parameters.getMapping());
        }
        acn.setUserData(userData);
        this.sendNotification(acn);
    }

    private String consolidatedHealth() {
        ThresholdHealth consolidatedHealth = ThresholdHealth.NOT_APPLICABLE;
        Iterator<ThresholdAttribute> iter = this.thresholdAttributeList.valueIterator();
        while (iter.hasNext()) {
            ThresholdAttribute attribute = iter.next();
            ThresholdHealth health = attribute.getCurrentHealth();
            consolidatedHealth = consolidatedHealth.getWorse(health);
        }
        return consolidatedHealth.toString();
    }

    public Iterator<?> getThresholdAttributes() {
        return this.thresholdAttributeList.iterator();
    }

    public void setLocalSearchPath(String localSearchPath) {
        if (null == localSearchPath) {
            return;
        }
        StringBuffer searchPath = new StringBuffer(localSearchPath);
        searchPath.append("/").append(this.serviceName);
        this.servicePath = searchPath.toString();
    }
}

