/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.MBeanRepository;
import com.cognos.pogo.monitoring.jmx.aggregator.HealthAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCache;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheFactory;
import com.cognos.pogo.monitoring.jmx.proxy.MBeanCacheWithCMAttributes;
import com.cognos.pogo.monitoring.jmx.proxy.UpdateGroupsInterface;
import com.cognos.pogo.monitoring.jmx.threshold.ServiceHealthAddIn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MultipleHealthAddIn
extends ServiceHealthAddIn
implements UpdateGroupsInterface {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MultipleHealthAddIn.class.getName());
    private final ObjectName objectPattern;
    private ArrayList<MBeanCacheWithCMAttributes> beans;

    public MultipleHealthAddIn(MBeanServer server, ObjectName objectPattern) {
        super(server, objectPattern);
        this.objectPattern = objectPattern;
    }

    @Override
    public Object getHealth() {
        HealthAttributeAggregator healthAggregator = new HealthAttributeAggregator();
        Iterator<MBeanCacheWithCMAttributes> it = this.beans.iterator();
        while (it.hasNext()) {
            Object healthAt = this.getHealthAt(it.next());
            healthAggregator.combine(healthAt);
        }
        return healthAggregator.getAggregation();
    }

    private Object getHealthAt(MBeanCache bean) {
        try {
            Object health = bean.getAttribute("Health");
            if (cat.isDebugEnabled()) {
                cat.debug(this + ".getHealthAt(" + bean + "): objectPattern=[" + this.objectPattern + "] = " + health);
            }
            return health;
        }
        catch (JMException e) {
            cat.debug(this + ".getHealthAt(" + bean + ") failed, objectPattern=[" + this.objectPattern + "]");
            return null;
        }
    }

    @Override
    public void updateGroups(MBeanRepository repository) {
        this.updateMBeans(repository.getPattern(this.objectPattern));
    }

    public void updateMBeans(MBeanRepository repository) {
        Collection<ObjectName> objectNames = repository.getObjectNames();
        this.beans = new ArrayList();
        for (ObjectName objectName : objectNames) {
            DynamicMBean dynamicMBean = repository.get(objectName);
            try {
                MBeanCacheWithCMAttributes beanCache = MBeanCacheFactory.getInstance(dynamicMBean);
                beanCache.setObjectName(objectName);
                beanCache.setBeanCacheName(objectName.toString());
                beanCache.registerAttributeForIsolatedCaching("Health");
                this.beans.add(beanCache);
                if (!cat.isDebugEnabled()) continue;
                cat.debug(this + ".updateMBeans(): caching Health attribute of [" + objectName + "])");
            }
            catch (MBeanException e) {
                cat.warn("Error creating bean cache, ", (Throwable)e);
            }
        }
    }
}

