/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdComparable;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import com.cognos.pogo.util.PogoLogger;
import java.util.Map;

public class ThresholdAttribute {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ThresholdParameters parameters;
    protected ThresholdHealth currentHealth = ThresholdHealth.NOT_APPLICABLE;
    private ThresholdComparable currentValue;
    private ThresholdComparable oldValue;
    private ThresholdComparable crossedThreshold;
    private static boolean notifyAllPoor;

    public ThresholdAttribute(ThresholdParameters parameters) {
        this.parameters = parameters;
        this.checkNotifyPoor();
    }

    private void checkNotifyPoor() {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        try {
            String value = configuration.getValue("DISP.threshold.notifyPoor", false);
            notifyAllPoor = Boolean.valueOf(value);
        }
        catch (CCLConfigurationException e) {
            log.debug("Exception getting notifyPoor ", e);
        }
    }

    public ThresholdHealth check(ThresholdComparable newValue) {
        boolean ret = false;
        ThresholdHealth newHealth = this.parameters.check(newValue);
        if (this.thresholdCrossed(newHealth)) {
            if (this.crossedThreshold != null && this.crossedThreshold.withinHysteresisRange(this.currentValue) && this.crossedThreshold.withinHysteresisRange(newValue)) {
                ret = false;
            } else {
                this.crossedThreshold = this.parameters.getCrossedThreshold();
                this.oldValue = this.currentValue;
                ret = true;
            }
        }
        this.currentHealth = newHealth;
        this.currentValue = newValue;
        if (ret) {
            return this.currentHealth;
        }
        return null;
    }

    protected boolean thresholdCrossed(ThresholdHealth newHealth) {
        if (!newHealth.equals(this.currentHealth)) {
            return true;
        }
        return notifyAllPoor && newHealth.equals(ThresholdHealth.POOR);
    }

    public ThresholdHealth getCurrentHealth() {
        return this.currentHealth;
    }

    public ThresholdParameters getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getMapping() {
        return this.parameters.getMapping();
    }

    public Comparable<?> getOldValue() {
        if (this.oldValue == null) {
            return null;
        }
        return this.oldValue.getValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThresholdAttribute) {
            ThresholdAttribute other = (ThresholdAttribute)obj;
            return this.parameters.equals(other.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    static boolean isNotifyAllPoor() {
        return notifyAllPoor;
    }
}

