/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.proxy.NotifyingDynamicMBean;
import com.cognos.pogo.monitoring.jmx.threshold.MBeanHealth;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdLoggingReceiver;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerMBean;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdPersister;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdReceiverList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ThresholdManager
extends MetricNotificationSupport
implements ThresholdManagerMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ThresholdManager.class.getName());
    private ThresholdReceiverList thresholdReceiverList = new ThresholdReceiverList();
    private final ThresholdLoggingReceiver thresholdLoggingReceiver;
    private ThresholdPersister thresholdPersister;
    private CompositeType compositeType;
    private String[] itemNames = new String[]{"beanName", "attributeName", "thresholdValue"};

    protected ThresholdManager() {
        this(new ThresholdLoggingReceiver(), new ThresholdPersister());
    }

    public ThresholdManager(ThresholdLoggingReceiver thresholdLoggingReceiver, ThresholdPersister thresholdPersister) {
        this.thresholdLoggingReceiver = thresholdLoggingReceiver;
        this.thresholdPersister = thresholdPersister;
        this.createCompositeType();
    }

    @Override
    public void writeThreshold(String mbeanName, String attributeName, String higherSidePoor, boolean higherSidePoorExclusiveFlag, String higherSideAverage, boolean higherSideAverageExclusiveFlag, String lowerSideAverage, boolean lowerSideAverageExclusiveFlag, String lowerSidePoor, boolean lowerSidePoorExclusiveFlag) throws Exception {
        this.writeThreshold(mbeanName, attributeName, higherSidePoor, higherSidePoorExclusiveFlag, higherSideAverage, higherSideAverageExclusiveFlag, lowerSideAverage, lowerSideAverageExclusiveFlag, lowerSidePoor, lowerSidePoorExclusiveFlag, true);
    }

    @Override
    public void writeThreshold(String mbeanName, String attributeName, String higherSidePoor, boolean higherSidePoorExclusiveFlag, String higherSideAverage, boolean higherSideAverageExclusiveFlag, String lowerSideAverage, boolean lowerSideAverageExclusiveFlag, String lowerSidePoor, boolean lowerSidePoorExclusiveFlag, boolean activeDispatcher) throws Exception {
        ThresholdParameters thresholdParameters = new ThresholdParameters(higherSidePoor, higherSidePoorExclusiveFlag, higherSideAverage, higherSideAverageExclusiveFlag, lowerSideAverage, lowerSideAverageExclusiveFlag, lowerSidePoor, lowerSidePoorExclusiveFlag);
        this.createThreshold(mbeanName, attributeName, thresholdParameters);
        if (activeDispatcher) {
            this.thresholdPersister.writeToCM(mbeanName, attributeName, thresholdParameters);
        }
    }

    public void createThreshold(String mbeanName, String attributeName, ThresholdParameters thresholdParameters) throws InstanceNotFoundException, MalformedObjectNameException, IntrospectionException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName mBeanObjectName = ObjectName.getInstance(mbeanName);
        HealthBroadcaster healthBroadcaster = this.getThresholdReceiver(mBeanObjectName);
        healthBroadcaster.getReceiver().addThresholdParameters(attributeName, thresholdParameters);
        this.notifyCurrentValue(attributeName, healthBroadcaster);
    }

    private void notifyCurrentValue(String attributeName, HealthBroadcaster healthBroadcaster) throws ReflectionException {
        NotifyingDynamicMBean bean = healthBroadcaster.getBroadcaster();
        try {
            Comparable currentValue = (Comparable)bean.getAttribute(attributeName);
            AttributeChangeNotification notification = this.createNotification(attributeName, null, currentValue);
            healthBroadcaster.getReceiver().handleNotification(notification, null);
        }
        catch (JMException e) {
            cat.error("Attribute not found, health not checked.", (Throwable)e);
        }
    }

    private HealthBroadcaster getThresholdReceiver(ObjectName mBeanObjectName) throws InstanceNotFoundException, MalformedObjectNameException, NullPointerException, IntrospectionException, ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        HealthBroadcaster receiver = this.thresholdReceiverList.get(mBeanObjectName);
        if (receiver == null) {
            throw new InstanceNotFoundException(mBeanObjectName.toString());
        }
        return receiver;
    }

    @Override
    public void clearThreshold(String mbeanName, String attributeName) throws Exception {
        this.clearThreshold(mbeanName, attributeName, true);
    }

    @Override
    public void clearThreshold(String mbeanName, String attributeName, boolean activeDispatcher) throws Exception {
        ObjectName mBeanObjectName = ObjectName.getInstance(mbeanName);
        HealthBroadcaster thresholdReceiver = this.thresholdReceiverList.get(mBeanObjectName);
        if (thresholdReceiver != null) {
            thresholdReceiver.getReceiver().clearThreshold(attributeName);
        }
        if (activeDispatcher) {
            this.thresholdPersister.remove(mbeanName, attributeName);
        }
    }

    @Override
    public CompositeData readThreshold(String mbeanName, String attributeName) throws JMException {
        return this.readThreshold(mbeanName, attributeName, true);
    }

    @Override
    public CompositeData readThreshold(String mbeanName, String attributeName, boolean activeDispatcher) throws JMException {
        HealthBroadcaster thresholdReceiver;
        try {
            ObjectName mBeanObjectName = ObjectName.getInstance(mbeanName);
            thresholdReceiver = this.thresholdReceiverList.get(mBeanObjectName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMException("Malformed object name: " + mbeanName);
        }
        if (thresholdReceiver == null) {
            throw new JMException("No MBean with name: " + mbeanName);
        }
        ThresholdParameters threshold = thresholdReceiver.getReceiver().getThresholdParameters(attributeName);
        if (threshold == null) {
            return null;
        }
        return threshold.getCompositeData();
    }

    @Override
    public void defineGroup(String groupName, String dispatcherNames) {
    }

    public void setLocalSearchPath(String localSearchPath) {
        this.thresholdPersister.setLocalSearchPath(localSearchPath);
    }

    public void addThresholdReceiver(ObjectName objectName, MBeanHealth receiver, NotifyingDynamicMBean beanTotal) {
        HealthBroadcaster healthBroadcaster = new HealthBroadcaster(receiver, beanTotal);
        this.thresholdReceiverList.add(objectName, healthBroadcaster);
        this.connectHealthNotification(healthBroadcaster);
    }

    private void connectHealthNotification(HealthBroadcaster healthBroadcaster) {
        healthBroadcaster.getBroadcaster().addNotificationListener(healthBroadcaster.getReceiver(), null, null);
        try {
            healthBroadcaster.getReceiver().addNotificationListener(this.thresholdLoggingReceiver, null, null);
        }
        catch (IllegalArgumentException e) {
            cat.debug("Notification listener ready registered; ignored", (Throwable)e);
        }
    }

    @Override
    public CompositeData[] getThresholds() {
        ArrayList<CompositeDataSupport> thresholdList = new ArrayList<CompositeDataSupport>();
        Iterator<ObjectName> iter = this.thresholdReceiverList.iterator();
        while (iter.hasNext()) {
            ObjectName objectName = iter.next();
            HealthBroadcaster broadcaster = this.thresholdReceiverList.get(objectName);
            MBeanHealth receiver = broadcaster.getReceiver();
            Iterator<?> iterator = receiver.getThresholdAttributes();
            while (iterator.hasNext()) {
                String attributeName = (String)iterator.next();
                ThresholdParameters parameters = receiver.getThresholdParameters(attributeName);
                CompositeData composite = parameters.getCompositeData();
                Object[] values = new Object[]{objectName.toString(), attributeName, composite};
                try {
                    CompositeDataSupport compositeData = new CompositeDataSupport(this.compositeType, this.itemNames, values);
                    thresholdList.add(compositeData);
                }
                catch (OpenDataException e) {
                    cat.error("catch", (Throwable)e);
                }
            }
        }
        CompositeData[] data = new CompositeData[thresholdList.size()];
        thresholdList.toArray(data);
        return data;
    }

    private void createCompositeType() {
        try {
            String[] itemDesc = new String[]{"beanName", "attributeName", "thresholdValue"};
            OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, ThresholdParameters.getType()};
            this.compositeType = new CompositeType("ThresholdNames", "threshold names", this.itemNames, itemDesc, itemTypes);
        }
        catch (OpenDataException e) {
            cat.error("catch", (Throwable)e);
        }
    }

    @Override
    public void recreateThresholds() {
        this.thresholdPersister.recreateThresholds(this);
    }

    @Override
    public void recreateConsolidatedThresholds() {
        this.thresholdPersister.recreateConsolidatedThresholds(this);
    }

    public class HealthBroadcaster {
        private final MBeanHealth receiver;
        private final NotifyingDynamicMBean broadcaster;

        public HealthBroadcaster(MBeanHealth receiver, NotifyingDynamicMBean beanTotal) {
            this.receiver = receiver;
            this.broadcaster = beanTotal;
        }

        public NotifyingDynamicMBean getBroadcaster() {
            return this.broadcaster;
        }

        public MBeanHealth getReceiver() {
            return this.receiver;
        }
    }
}

