/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.threshold;

import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameterHigh;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameterLow;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameterMiddle;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdParameters;
import javax.management.InvalidAttributeValueException;

public class ThresholdParametersFactory {
    public static ThresholdParameters createThresholdParameters(String higherSidePoor, boolean higherSidePoorExclusiveFlag, String higherSideAverage, boolean higherSideAverageExclusiveFlag, String lowerSideAverage, boolean lowerSideAverageExclusiveFlag, String lowerSidePoor, boolean lowerSidePoorExclusiveFlag) throws InvalidAttributeValueException {
        ParameterType parameterType = new ParameterType(higherSidePoor, higherSideAverage, lowerSideAverage, lowerSidePoor);
        if (parameterType.isMiddle()) {
            return new ThresholdParameterMiddle(higherSidePoor, higherSidePoorExclusiveFlag, higherSideAverage, higherSideAverageExclusiveFlag, lowerSideAverage, lowerSideAverageExclusiveFlag, lowerSidePoor, lowerSidePoorExclusiveFlag);
        }
        if (parameterType.isHigh()) {
            return new ThresholdParameterHigh(higherSidePoor, higherSidePoorExclusiveFlag, higherSideAverage, higherSideAverageExclusiveFlag, lowerSideAverage, lowerSideAverageExclusiveFlag, lowerSidePoor, lowerSidePoorExclusiveFlag);
        }
        if (parameterType.isLow()) {
            return new ThresholdParameterLow(higherSidePoor, higherSidePoorExclusiveFlag, higherSideAverage, higherSideAverageExclusiveFlag, lowerSideAverage, lowerSideAverageExclusiveFlag, lowerSidePoor, lowerSidePoorExclusiveFlag);
        }
        return null;
    }

    private static class ParameterType {
        private final String higherSidePoor;
        private final String higherSideAverage;
        private final String lowerSideAverage;
        private final String lowerSidePoor;

        ParameterType(String higherSidePoor, String higherSideAverage, String lowerSideAverage, String lowerSidePoor) {
            this.higherSidePoor = higherSidePoor;
            this.higherSideAverage = higherSideAverage;
            this.lowerSideAverage = lowerSideAverage;
            this.lowerSidePoor = lowerSidePoor;
        }

        boolean isMiddle() {
            return !this.higherSidePoor.equals("") && !this.higherSideAverage.equals("") && !this.lowerSidePoor.equals("") && !this.lowerSideAverage.equals("");
        }

        boolean isHigh() {
            return !this.higherSidePoor.equals("") && !this.higherSideAverage.equals("");
        }

        boolean isLow() {
            return !this.lowerSidePoor.equals("") && !this.lowerSideAverage.equals("");
        }
    }
}

