/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.monitoring.jmx.PogoJMXAuthenticator;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanServerConnection;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServer;

public class PogoMBeanHessianServerConnection
extends PogoMBeanServerConnection {
    public PogoMBeanHessianServerConnection(MBeanServer server) {
        super(server);
    }

    @Override
    protected String getConnectionString() {
        NodeID selfNodeId = NodeID.getSelf();
        return this.getHessianUrl(selfNodeId);
    }

    @Override
    protected void startConnector() throws MalformedURLException, IOException {
        PogoJMXAuthenticator authenticator = new PogoJMXAuthenticator();
        this.environment.put("jmx.remote.authenticator", authenticator);
        this.environment.put("jmx.remote.x.http.use.external.web.container", Boolean.TRUE);
        super.startConnector();
    }

    private String getHessianUrl(NodeID nodeId) {
        StringBuffer hostPortContext = new StringBuffer(nodeId.getHost());
        hostPortContext.append(":");
        hostPortContext.append(nodeId.getPort());
        String path = nodeId.getPath();
        int slash = path.indexOf(47, 1);
        hostPortContext.append(path.substring(0, slash));
        String protocol = nodeId.getProtocol();
        return this.getJmxUrl(hostPortContext, protocol);
    }

    protected String getJmxUrl(StringBuffer hostPortContext, String protocol) {
        return PogoMBeanServer.getJmxUrl(protocol.equalsIgnoreCase("https"), hostPortContext.toString());
    }
}

