/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PortProperty;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.XSLTProcessor;

public class PogoMBeanHttpServerConnector
extends PogoMBeanServerConnection {
    private static final PogoLogger log = PogoLogger.getLogger();
    private int port;

    public PogoMBeanHttpServerConnector(MBeanServer server) {
        super(server);
    }

    @Override
    protected String getConnectionString() {
        return "http://localhost:" + this.port;
    }

    @Override
    public void start() throws IOException {
        this.httpStart();
    }

    private void httpStart() {
        this.port = PortProperty.getPortFromProperty("mbeanhttpport");
        if (this.port != -1) {
            try {
                this.startHTTPConnector(this.port);
            }
            catch (JMException e) {
                log.info("Unable to start HTTP Server", e);
            }
        }
    }

    private void startHTTPConnector(int port) throws JMException {
        ObjectName httpAdaptorObjectName = this.registerHttpAdaptor();
        ObjectName processorObjectName = this.registerXSLTProcessor();
        this.setHttpAttributes(httpAdaptorObjectName, processorObjectName, port);
        this.server.invoke(httpAdaptorObjectName, "start", null, null);
    }

    private void setHttpAttributes(ObjectName httpAdaptorObjectName, ObjectName processorObjectName, int port) throws JMException {
        this.server.setAttribute(httpAdaptorObjectName, new Attribute("ProcessorName", processorObjectName));
        this.server.setAttribute(httpAdaptorObjectName, new Attribute("Port", new Integer(port)));
    }

    private ObjectName registerXSLTProcessor() throws JMException {
        ObjectName processorName = new ObjectName("Server:name=XSLTProcessor");
        XSLTProcessor processor = new XSLTProcessor();
        this.server.registerMBean(processor, processorName);
        return processorName;
    }

    private ObjectName registerHttpAdaptor() throws JMException {
        ObjectName name = new ObjectName("Server:name=HttpAdaptor");
        HttpAdaptor adaptor = new HttpAdaptor();
        this.server.registerMBean(adaptor, name);
        return name;
    }
}

