/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PogoMBeanRemover {
    private static final String HEALTH = "health";
    private static final String SERVICE_OPERATIONAL_STATUS = "ServiceOperationalStatus";
    private static final String SERVICE_HEALTH = "ServiceHealth";
    private static final String METRIC_HEALTH = "MetricHealth";
    private static final String METRICS = "Metrics";
    private static PogoLogger log = PogoLogger.getLogger();
    private MBeanServer server;

    public PogoMBeanRemover() {
        this(PogoMBeanServer.getInstance().getServer());
    }

    public PogoMBeanRemover(MBeanServer server) {
        this.server = server;
    }

    public void removeService(String serviceName) {
        try {
            ObjectName servicePattern = MBeanUtils.getServicePattern(serviceName);
            this.removePattern(servicePattern);
        }
        catch (MalformedObjectNameException e) {
            log.error("Error in service pattern ", e);
        }
    }

    public boolean metricsExist() {
        try {
            ObjectName pattern = this.getPatternForType(METRICS);
            return this.server.queryNames(pattern, null).size() > 0;
        }
        catch (MalformedObjectNameException e) {
            log.error("Error in pattern ", e);
            return false;
        }
    }

    public void removeMetrics() {
        this.remove(METRICS);
        this.remove(METRIC_HEALTH);
        this.remove(SERVICE_HEALTH);
        this.remove(SERVICE_OPERATIONAL_STATUS);
        this.remove(HEALTH);
    }

    private void remove(String type) {
        try {
            ObjectName pattern = this.getPatternForType(type);
            this.removePattern(pattern);
        }
        catch (MalformedObjectNameException e) {
            log.error("Error in pattern for type " + type, e);
        }
    }

    private ObjectName getPatternForType(String type) throws MalformedObjectNameException {
        return MBeanUtils.getAllServicesPattern(type);
    }

    private void removePattern(ObjectName servicePattern) {
        Set<ObjectName> queryNames = this.server.queryNames(servicePattern, null);
        for (ObjectName objectName : queryNames) {
            try {
                this.server.unregisterMBean(objectName);
                log.debug("Removed MBean: ", objectName);
            }
            catch (Exception e) {
                log.error("Error removing MBean " + objectName, e);
            }
        }
    }
}

