/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public abstract class PogoMBeanServerConnection {
    private static PogoLogger log = PogoLogger.getLogger();
    protected final MBeanServer server;
    protected Map<String, Object> environment = new HashMap<String, Object>();
    private JMXConnectorServer connectorServer = null;

    public PogoMBeanServerConnection(MBeanServer server) {
        this.server = server;
    }

    public void start() throws IOException {
        this.startConnector();
    }

    public void stop() throws IOException {
        if (this.connectorServer != null) {
            this.connectorServer.stop();
        }
    }

    protected void startConnector() throws MalformedURLException, IOException {
        JMXServiceURL address = new JMXServiceURL(this.getConnectionString());
        JMXConnectorServer cntorServer = JMXConnectorServerFactory.newJMXConnectorServer(address, this.environment, this.server);
        cntorServer.start();
        this.connectorServer = cntorServer;
        log.debug("Started JMX connector at ", address);
    }

    protected abstract String getConnectionString();
}

