/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.monitoring.jmx.utils.PortProperty;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Element;

public class PogoRmiAuthenticationConfiguration {
    private static final String NO_PORT_SPECIFIED = "0";
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ICCLConfiguration configuration;
    private int port;
    private String[] credentials;

    public PogoRmiAuthenticationConfiguration(ICCLConfiguration configuration) {
        this.configuration = configuration;
        this.extractPortAndCredential();
    }

    private void extractPortAndCredential() {
        this.port = this.extractPortFromConfiguration();
        if (this.port != -1) {
            this.credentials = this.extractCredentials();
        } else {
            this.port = this.extractPortFromProperty();
        }
    }

    public int getPort() {
        return this.port;
    }

    public String[] getCredentials() {
        return this.credentials;
    }

    private int extractPortFromConfiguration() {
        try {
            String value = this.configuration.getValue("jmxPort", false);
            if (value != null && !value.equals("") && !value.equals(NO_PORT_SPECIFIED)) {
                return Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            log.warn("Unable to extract port from configuration: ", e);
        }
        return -1;
    }

    private int extractPortFromProperty() {
        return PortProperty.getPortFromProperty("rmiregistryport");
    }

    private String[] extractCredentials() {
        try {
            Element valueElement = this.configuration.getValueElement("jmxCredential", true);
            Element credentialElement = valueElement.element("credential");
            if (credentialElement != null) {
                String username = credentialElement.element("username").getTextTrim();
                String password = credentialElement.element("password").getTextTrim();
                return new String[]{username, password};
            }
        }
        catch (CCLConfigurationException e) {
            log.warn("Unable to extract user credentials from configuration: ", e);
        }
        return null;
    }
}

