/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.utils;

import com.cognos.pogo.util.PogoLogger;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class PogoRmiRegistry {
    private static PogoLogger log = PogoLogger.getLogger();
    private int registryPort;
    private int jmxServerPort;
    private Registry registry;

    public void setPort(int rmiPort) {
        this.registryPort = rmiPort;
    }

    public void setServerPort(int jmxPort) {
        this.jmxServerPort = jmxPort;
    }

    public boolean isEnabled() {
        return this.registryPort != -1;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public int getServerPort() {
        return this.jmxServerPort;
    }

    public void checkRMIRegistryAndStart() {
        if (!this.checkRMIRegistry()) {
            this.startRMIRegisty();
        }
    }

    boolean checkRMIRegistry() {
        return this.registry != null;
    }

    private void startRMIRegisty() {
        try {
            this.registry = LocateRegistry.createRegistry(this.registryPort);
        }
        catch (RemoteException e) {
            log.debug("RemoteException locating registry on port ", this.registryPort, e);
        }
    }

    public void stopRMIRegistry() {
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                log.error("Unable to stop RMI registry", e);
            }
            this.registry = null;
        }
    }
}

