/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.launcher;

import com.cognos.pogo.osgi.launcher.OSGiFrameworkLauncher;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OsgiHandler
extends BasicHandler {
    private static final String COGNOS_CONFIGURATION = "cognos/configuration";
    private static final String SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static PogoLogger log = PogoLogger.getLogger();
    public static final String POGO_BUNDLE_CONTEXT = "com.ibm.cognos.pogo.bundle.context";
    private OSGiFrameworkLauncher launcher;
    private HashMap<String, String> eclipseConfig;

    public OsgiHandler() {
        this(new OSGiFrameworkLauncher());
    }

    public OsgiHandler(OSGiFrameworkLauncher osgiFrameworkLauncher) {
        super(log.getNativeLogger());
        this.launcher = osgiFrameworkLauncher;
    }

    @Override
    public void contextualize(Element handlerElement) throws PogoException {
        super.contextualize(handlerElement);
        this.eclipseConfig = this.getEclipseConfig(handlerElement);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        if (!this.eclipseConfig.containsKey(OSGI_CONFIGURATION_AREA)) {
            String defaultConfigurationArea = this.getDefaultConfigurationArea(engine);
            this.eclipseConfig.put(OSGI_CONFIGURATION_AREA, defaultConfigurationArea);
        }
    }

    private String getDefaultConfigurationArea(PogoEngine engine) {
        File tempdir = (File)engine.getContextAttribute(SERVLET_CONTEXT_TEMPDIR);
        File configurationDirectory = new File(tempdir, COGNOS_CONFIGURATION);
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdirs();
        }
        return configurationDirectory.getAbsolutePath();
    }

    private HashMap<String, String> getEclipseConfig(Element handlerElement) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (Element element : this.getConfigurationItems(handlerElement)) {
            String name = element.element("name").getText();
            String value = element.element("value").getText();
            config.put(name, value);
        }
        return config;
    }

    private List<Element> getConfigurationItems(Element handlerElement) {
        return handlerElement.element("configuration").elements("item");
    }

    @Override
    public void invokeImpl(MessageContext messagecontext) throws PogoException {
    }

    @Override
    public void start() {
        try {
            Bundle framework = this.launcher.start(this.eclipseConfig);
            BundleContext bundleContext = framework.getBundleContext();
            this.saveBundleContext(bundleContext);
        }
        catch (Exception e) {
            log.error("Exception starting OSGi: ", e);
        }
    }

    private void saveBundleContext(BundleContext bundleContext) {
        PogoEngine pogoEngine = this.getPogoEngine();
        PogoEngineContext context = pogoEngine.getContext();
        context.setAttribute(POGO_BUNDLE_CONTEXT, bundleContext);
        log.debug("saved bundleContext at ", POGO_BUNDLE_CONTEXT, " = ", bundleContext);
    }

    @Override
    public void stop() {
        if (this.launcher != null) {
            try {
                this.launcher.waitForStop();
            }
            catch (InterruptedException e) {
                log.debug("Exception waiting for OSGi framework terrmination: ", e);
            }
        }
    }

    HashMap<String, String> getEclipseConfigForTesting() {
        return this.eclipseConfig;
    }
}

