/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.osgi.launcher;

import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class WatchedBundles {
    private static final String FILE_PREFIX = "file://";
    private static final PogoLogger log = PogoLogger.getLogger();
    private Map<File, Bundle> installedBundles = Collections.synchronizedMap(new HashMap());

    public Map<File, Bundle> installFiles(BundleContext bundleContext, List<File> files) {
        for (File file : files) {
            log.debug("Installing bundle for file: ", file);
            this.installFile(bundleContext, file);
        }
        return this.installedBundles;
    }

    private void installFile(BundleContext bundleContext, File file) {
        try {
            String fileUri = this.constructFileUriString(file);
            Bundle bundle = bundleContext.installBundle(fileUri);
            this.installedBundles.put(file, bundle);
            log.debug("Added to installed: ", file);
        }
        catch (Exception e) {
            log.error("Unable to install " + file, e);
        }
    }

    String constructFileUriString(File file) {
        return FILE_PREFIX + file.toURI().getPath();
    }

    public void removeFiles(ArrayList<File> files) {
        for (File file : files) {
            log.debug("Removing bundle for file: ", file);
            this.remove(file);
        }
    }

    void remove(File file) {
        if (this.installedBundles.containsKey(file)) {
            Bundle bundle = this.installedBundles.get(file);
            try {
                this.stopAndUninstallBundle(bundle);
            }
            catch (BundleException e) {
                log.error("Unable to stop or uninstall bundle: " + bundle.getSymbolicName(), e);
            }
            this.installedBundles.remove(file);
        }
    }

    private void stopAndUninstallBundle(Bundle bundle) throws BundleException {
        if (this.bundleIsNotUninstalled(bundle)) {
            bundle.stop();
            bundle.uninstall();
        }
    }

    public void startInstalled() {
        Iterator<Map.Entry<File, Bundle>> iterator = this.installedBundles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, Bundle> installedBundle = iterator.next();
            if (this.startBundle(installedBundle.getValue())) continue;
            iterator.remove();
        }
    }

    private boolean startBundle(Bundle bundle) {
        try {
            if (this.shouldStartBundle(bundle)) {
                log.debug("Starting bundle: ", bundle.getSymbolicName());
                bundle.start();
            }
        }
        catch (BundleException e) {
            log.error("Unable to start bundle: " + bundle.getSymbolicName(), e);
            return false;
        }
        return true;
    }

    private boolean shouldStartBundle(Bundle bundle) {
        return this.bundleIsNotActive(bundle) && this.bundleIsNotUninstalled(bundle) && this.bundleIsNotFragment(bundle);
    }

    private boolean bundleIsNotActive(Bundle bundle) {
        return bundle.getState() != 32;
    }

    private boolean bundleIsNotUninstalled(Bundle bundle) {
        return bundle.getState() != 1;
    }

    private boolean bundleIsNotFragment(Bundle bundle) {
        String fragmentHost = "Fragment-Host";
        return this.getBundleHeader(bundle, fragmentHost) == null;
    }

    private String getBundleHeader(Bundle bundle, String fragmentHost) {
        return (String)bundle.getHeaders().get(fragmentHost);
    }

    Bundle getBundle(File file) {
        return this.installedBundles.get(file);
    }
}

