/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.SoftReferenceObjectPool;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RequestIDGenerator {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RequestIDGenerator.class.getName());
    private byte[] basePhrase = null;
    private long iSequence;
    private Random random;
    private ObjectPool pool;
    private static final char[] hex_chars = new char[]{'s', 'l', 'v', 'G', '9', 'q', 'w', '4', 'd', 'j', '2', 'h', 'y', '8', 'C', 'M'};

    public RequestIDGenerator(String basephrase) {
        DigesterFactory factory = new DigesterFactory();
        this.pool = new SoftReferenceObjectPool((PoolableObjectFactory)factory);
        this.random = new Random();
        this.basePhrase = basephrase.getBytes();
        this.iSequence = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextID(String passportId) {
        long r;
        long seq;
        RequestIDGenerator requestIDGenerator = this;
        synchronized (requestIDGenerator) {
            seq = this.iSequence++;
            r = this.random.nextLong();
        }
        Digester digester = null;
        try {
            digester = (Digester)this.pool.borrowObject();
            if (this.basePhrase != null) {
                digester.daos.write(this.basePhrase);
            }
            if (passportId != null) {
                digester.daos.write(passportId.getBytes());
            }
            digester.daos.writeLong(seq);
            digester.daos.writeLong(r);
            String sDigest = digester.getDigest();
            if (cat.isDebugEnabled()) {
                cat.debug("Generated request id: " + sDigest);
            }
            String string = sDigest;
            return string;
        }
        catch (Exception x) {
            cat.fatalError("Exception occured when trying to get NessageDigest from pool.", (Throwable)x);
        }
        finally {
            if (digester != null) {
                try {
                    this.pool.returnObject((Object)digester);
                }
                catch (Exception e) {
                    cat.error("exception returning messageDigest object to pool", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBasePhrase(String string) {
        RequestIDGenerator requestIDGenerator = this;
        synchronized (requestIDGenerator) {
            this.basePhrase = string.getBytes();
        }
    }

    public static void main(String[] args) {
        RequestIDGenerator gen = new RequestIDGenerator("Somebasephrase");
        long t0 = System.currentTimeMillis();
        int N = 10000;
        String[] ids = new String[N];
        for (int i = 0; i < N; ++i) {
            ids[i] = gen.getNextID("someBogusPassportID");
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Generated " + N + " ids, took " + (t1 - t0) + "ms");
        double tper = (double)(t1 - t0) / (double)N;
        System.out.println("That's " + tper + "ms per GUID");
    }

    private class DigesterFactory
    extends BasePoolableObjectFactory {
        private DigesterFactory() {
        }

        public Object makeObject() throws Exception {
            return new Digester();
        }

        public void activateObject(Object o) throws Exception {
            ((Digester)o).activate();
        }

        public void passivateObject(Object o) throws Exception {
            ((Digester)o).passivate();
        }
    }

    private class Digester {
        private MessageDigest digester;
        private HackByteArrayOutputStream baos;
        private DataOutputStream daos;
        private StringBuffer sb;

        Digester() throws Exception {
            try {
                this.digester = MessageDigest.getInstance("SHA");
                this.baos = new HackByteArrayOutputStream(256);
                this.daos = new DataOutputStream(this.baos);
                this.sb = new StringBuffer(40);
            }
            catch (NoSuchAlgorithmException e) {
                cat.fatalError(e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        String getDigest() {
            this.digester.update(this.baos.getBytes(), 0, this.baos.getLength());
            byte[] bytes = this.digester.digest();
            this.hexify(bytes);
            return this.sb.toString();
        }

        void activate() {
            this.digester.reset();
            this.baos.reset();
        }

        void passivate() {
            this.digester.reset();
        }

        private void hexify(byte[] bytes) {
            this.sb.setLength(0);
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                this.sb.append(hex_chars[b & 0xF]).append(hex_chars[(b & 0xF0) >> 4]);
            }
        }
    }

    private class HackByteArrayOutputStream
    extends ByteArrayOutputStream {
        HackByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        byte[] getBytes() {
            return this.buf;
        }

        public int getLength() {
            return this.count;
        }
    }
}

