/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.Dereferencer;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.dom4j.Dom4jBodyFault;
import com.cognos.pogo.pdk.dom4j.Dom4jBodyHandler;
import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.pogo.util.EchoInputStream;
import com.cognos.pogo.util.EchoReader;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class SOAPEnvelope
implements SOAPXMLSource,
Envelope {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final String FAULT_CODE = "faultcode";
    private static final String FAULT_STRING = "faultstring";
    public static final String FAULT_DETAIL = "detail";
    static final String ARRAY_TYPE = "Array";
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    static final Namespace NS_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace NS_XSD = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final Namespace NS_XSI = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static final String SOAP_ENC_ARRAY = NS_SOAP_ENC.getPrefix() + ":" + "Array";
    public static final String XSD_STRING = NS_XSD.getPrefix() + ":string";
    public static final String XSD_INT = NS_XSD.getPrefix() + ":int";
    public static final String XSD_INTEGER = NS_XSD.getPrefix() + ":integer";
    public static final String XSD_BOOLEAN = NS_XSD.getPrefix() + ":boolean";
    public static final String XSD_NMTOKEN = NS_XSD.getPrefix() + ":NMTOKEN";
    public static final String XSD_LONG = NS_XSD.getPrefix() + ":long";
    public static final String XSD_DATA_ENCODING_ENUM = NS_XSD.getPrefix() + ":dataEncodingEnum";
    public static final String XSD_BASE64BINARY = NS_XSD.getPrefix() + ":base64Binary";
    public static final QName XSI_TYPE = DocumentHelper.createQName((String)"type", (Namespace)NS_XSI);
    public static final QName XSI_NIL = DocumentHelper.createQName((String)"nil", (Namespace)NS_XSI);
    public static final QName SOAP_ENC_ARRAYTYPE = DocumentHelper.createQName((String)"arrayType", (Namespace)NS_SOAP_ENC);
    private static final QName SOAP_ENV_HEADER = DocumentHelper.createQName((String)"Header", (Namespace)NS_SOAP_ENV);
    private static final QName SOAP_ENV_BODY = DocumentHelper.createQName((String)"Body", (Namespace)NS_SOAP_ENV);
    private static final QName SOAP_ENV_ENVELOPE = DocumentHelper.createQName((String)"Envelope", (Namespace)NS_SOAP_ENV);
    private static final QName SOAP_ENV_ENCODING_STYLE = DocumentHelper.createQName((String)"encodingStyle", (Namespace)NS_SOAP_ENV);
    public static final QName SOAP_ENV_FAULT = DocumentHelper.createQName((String)"Fault", (Namespace)NS_SOAP_ENV);
    public static final QName SOAP_ENV_MUST_UNDERSTAND = DocumentHelper.createQName((String)"mustUnderstand", (Namespace)NS_SOAP_ENV);
    public static final OutputFormat PRETTY_PRINT = OutputFormat.createPrettyPrint();
    public static final OutputFormat STANDARD_FORMAT = new OutputFormat();
    private static String ENCODING = "UTF-8";
    private Document envelope;
    private Element header;
    private Element body;
    private BodyFault bodyFault;
    private BodyHandler bodyHandler;
    private static SAXReaderPool saxReaderPool;

    protected SOAPEnvelope() {
        this(null, null);
    }

    protected SOAPEnvelope(SOAPEnvelope other) {
        this.envelope = DocumentHelper.createDocument();
        this.envelope.add(other.getEnvelope().createCopy());
    }

    protected SOAPEnvelope(Element eheader) {
        this(eheader, null);
    }

    protected SOAPEnvelope(Element eheader, Element ebody) {
        this.envelope = DocumentHelper.createDocument();
        Element rootElement = this.envelope.addElement(SOAP_ENV_ENVELOPE);
        rootElement.addAttribute(SOAP_ENV_ENCODING_STYLE, NS_SOAP_ENC.getURI());
        rootElement.add(NS_SOAP_ENV);
        rootElement.add(NS_SOAP_ENC);
        rootElement.add(NS_XSD);
        rootElement.add(NS_XSI);
        if (eheader != null) {
            rootElement.add(eheader);
            this.header = eheader;
        }
        if (ebody != null) {
            rootElement.add(ebody);
            this.body = ebody;
        }
    }

    public SOAPEnvelope(Document document) {
        this.envelope = document;
    }

    protected SOAPEnvelope(InputStream is) throws SOAPException {
        this.envelope = this.parseEnvelope(is);
    }

    protected SOAPEnvelope(Reader reader) throws SOAPException {
        this.envelope = this.parseEnvelope(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseEnvelope(Reader aReader) throws SOAPException {
        if (log.isDebugEnabled()) {
            return this.debugParseEnvelope(aReader);
        }
        PooledSAXReader reader = null;
        try {
            reader = this.getSAXReader();
            Dereferencer dereferencer = new Dereferencer();
            this.envelope = dereferencer.dereference(reader.read(aReader));
            this.envelope.getRootElement().add(NS_XSD);
        }
        catch (Exception dx) {
            this.throwSOAPException(dx, aReader);
        }
        finally {
            if (reader != null) {
                reader.release();
            }
        }
        return this.envelope;
    }

    private PooledSAXReader getSAXReader() {
        if (saxReaderPool == null) {
            saxReaderPool = SAXReaderPool.getInstance();
        }
        return saxReaderPool.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document debugParseEnvelope(Reader aReader) throws SOAPException {
        StringWriter echoWriter = new StringWriter();
        EchoReader echoReader = new EchoReader(echoWriter, aReader);
        PooledSAXReader reader = null;
        try {
            reader = this.getSAXReader();
            Dereferencer dereferencer = new Dereferencer();
            this.envelope = dereferencer.dereference(reader.read(echoReader));
            this.envelope.getRootElement().add(NS_XSD);
        }
        catch (DocumentException dx) {
            log.debug("Exception parsing SOAP envelope: ", dx.getMessage(), " parsed chars follow:");
            log.debug(echoWriter);
            this.throwSOAPException((Exception)((Object)dx), echoWriter);
        }
        catch (Exception dx) {
            this.throwSOAPException(dx, echoWriter);
        }
        finally {
            if (reader != null) {
                reader.release();
            }
        }
        return this.envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseEnvelope(InputStream is) throws SOAPException {
        if (log.isDebugEnabled()) {
            return this.debugParseEnvelope(is);
        }
        PooledSAXReader reader = null;
        try {
            reader = this.getSAXReader();
            Dereferencer dereferencer = new Dereferencer();
            this.envelope = dereferencer.dereference(reader.read(is));
            this.envelope.getRootElement().add(NS_XSD);
        }
        catch (Exception dx) {
            this.throwSOAPException(dx, is);
        }
        finally {
            if (reader != null) {
                reader.release();
            }
        }
        return this.envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document debugParseEnvelope(InputStream is) throws SOAPException {
        ByteArrayOutputStream baosEcho = new ByteArrayOutputStream();
        EchoInputStream isEcho = new EchoInputStream(baosEcho, is);
        PooledSAXReader reader = null;
        try {
            reader = this.getSAXReader();
            Dereferencer dereferencer = new Dereferencer();
            this.envelope = dereferencer.dereference(reader.read(isEcho));
            this.envelope.getRootElement().add(NS_XSD);
        }
        catch (DocumentException dx) {
            log.debug("Exception parsing SOAP envelope: ", dx.getMessage(), " parsed bytes follow:");
            try {
                log.debug(baosEcho.toString(ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                log.error("UnsupportedEncodingException,", e);
            }
            this.throwSOAPException((Exception)((Object)dx), baosEcho);
        }
        catch (Exception dx) {
            this.throwSOAPException(dx, baosEcho);
        }
        finally {
            if (reader != null) {
                reader.release();
            }
        }
        return this.envelope;
    }

    private void throwSOAPException(Exception rootCauseException, Object envelopeSource) throws SOAPException {
        String soapEnvelope = null;
        try {
            if (envelopeSource instanceof Reader) {
                Reader reader = (Reader)envelopeSource;
                reader.reset();
                if (reader.ready()) {
                    char[] cb = new char[10000];
                    reader.read(cb);
                    soapEnvelope = new String(cb);
                    if (soapEnvelope.length() == cb.length) {
                        soapEnvelope = soapEnvelope + "\n(SOAP envelope was truncated for logging purposes)\n";
                    }
                }
            } else if (envelopeSource instanceof InputStream) {
                InputStream is = (InputStream)envelopeSource;
                if (is.markSupported()) {
                    is.reset();
                    int nBytes = is.available();
                    if (nBytes > 0) {
                        byte[] bytes = new byte[nBytes];
                        is.read(bytes);
                        soapEnvelope = new String(bytes);
                    }
                }
            } else if (envelopeSource != null) {
                soapEnvelope = envelopeSource.toString();
            }
        }
        catch (Exception e) {
            soapEnvelope = "Can't retrieve offending SOAP envelope.";
        }
        SOAPException x = new SOAPException(DispatcherStrings.getInstance().getString("SOAPEnvelope.badEnvelope"));
        x.setDetails(rootCauseException, soapEnvelope);
        throw x;
    }

    public Element getEnvelope() {
        return this.envelope.getRootElement();
    }

    public Element getHeader() {
        if (this.header == null) {
            this.header = this.getEnvelope().element(SOAP_ENV_HEADER);
            if (this.header == null) {
                this.header = this.getEnvelope().addElement(SOAP_ENV_HEADER);
                if (this.body == null) {
                    this.body = this.getEnvelope().element(SOAP_ENV_BODY);
                }
                if (this.body != null) {
                    this.body.detach();
                    this.getEnvelope().add(this.body);
                }
            }
        }
        return this.header;
    }

    public void setHeader(Element newHeader) {
        if (this.header != null) {
            this.header.detach();
        }
        this.header = newHeader;
        this.getEnvelope().add(newHeader);
        if (this.body == null) {
            this.body = this.getEnvelope().element(SOAP_ENV_BODY);
        }
        if (this.body != null) {
            this.body.detach();
            this.getEnvelope().add(this.body);
        }
    }

    public Element getBody() {
        if (this.body != null) {
            return this.body;
        }
        this.body = this.getEnvelope().element(SOAP_ENV_BODY);
        if (this.body == null) {
            this.body = this.getEnvelope().addElement(SOAP_ENV_BODY);
        }
        return this.body;
    }

    @Override
    public void writeAsXML(OutputStream outStream) throws IOException {
        this.writeAsXML(outStream, STANDARD_FORMAT);
    }

    public void writeAsXML(Writer aWriter) throws IOException {
        this.writeAsXML(aWriter, STANDARD_FORMAT);
    }

    private void writeAsXML(OutputStream outStream, OutputFormat format) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(outStream, format);
        xmlWriter.write(this.envelope);
        xmlWriter.flush();
    }

    private void writeAsXML(Writer writer, OutputFormat format) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(this.envelope);
        xmlWriter.flush();
    }

    public String getFaultCode() {
        return this.getBodyFault().getFaultCode();
    }

    public String getFaultString() {
        return this.getBodyFault().getFaultString();
    }

    public Element createFaultElement(String faultcode, String faultstring, Element detail) {
        Element fault = this.getBody().addElement(SOAP_ENV_FAULT);
        fault.addElement(FAULT_CODE).addText(faultcode);
        fault.addElement(FAULT_STRING).addText(faultstring);
        if (detail != null) {
            fault.add(detail);
        }
        return fault;
    }

    public Element createFaultElement(String faultcode, String faultstring) {
        Element detailElement = DocumentHelper.createElement((String)FAULT_DETAIL);
        return this.createFaultElement(faultcode, faultstring, detailElement);
    }

    public Element getFault() {
        return this.getBody().element(SOAP_ENV_FAULT);
    }

    public Element getFaultDetail() {
        Element fault = this.getFault();
        return fault != null ? fault.element(FAULT_DETAIL) : null;
    }

    public Document getAsDocument() {
        return this.envelope;
    }

    public String getAsString() throws IOException {
        return this.getAsString(PRETTY_PRINT);
    }

    public String getAsString(OutputFormat format) throws IOException {
        ByteArrayOutputStream stream = StreamFactory.createByteArrayOutputStream();
        OutputStreamWriter writer = StreamFactory.createOutputStreamWriter(stream, ENCODING);
        this.writeAsXML(writer, format);
        return stream.toString(ENCODING);
    }

    public byte[] getAsBytesForSignatureCheck() throws IOException {
        ByteArrayOutputStream stream = StreamFactory.createByteArrayOutputStream();
        OutputStreamWriter writer = StreamFactory.createOutputStreamWriter(stream, ENCODING);
        this.writeAsXML(writer);
        return stream.toByteArray();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (IOException e) {
            log.debug("Exception caught while generating XML string: ", e);
            return e.toString();
        }
    }

    public void moveHeaderTo(SOAPEnvelope destination) {
        this.copyHeaderTo(destination);
    }

    public void copyHeaderTo(SOAPEnvelope destination) {
        this.moveHeaderWithOptionalRemoval(destination, false);
    }

    public void transferHeaderTo(SOAPEnvelope destination) {
        this.moveHeaderWithOptionalRemoval(destination, true);
    }

    private void moveHeaderWithOptionalRemoval(SOAPEnvelope destination, boolean removeHeaderFromSource) {
        if (this.header == null) {
            return;
        }
        this.header.detach();
        destination.setHeader(this.header);
        if (removeHeaderFromSource) {
            this.header = null;
        }
        this.copyNamespacesTo(destination);
    }

    public void copyNamespacesTo(SOAPEnvelope destination) {
        List nsList = this.envelope.getRootElement().declaredNamespaces();
        if (nsList != null) {
            for (Namespace aNs : nsList) {
                destination.getEnvelope().add((Namespace)aNs.clone());
            }
        }
    }

    public static void stripXSINilAttribute(Element anElement) {
        Attribute xsiNil = anElement.attribute(XSI_NIL);
        if (xsiNil != null) {
            xsiNil.detach();
        }
    }

    public static void setLoggerForTesting(PogoLogger log) {
        SOAPEnvelope.log = log;
    }

    public static void setSAXReaderPoolForTesting(SAXReaderPool saxReaderPool) {
        SOAPEnvelope.saxReaderPool = saxReaderPool;
    }

    public static String modifyEncodingForTesting(String newEncoding) {
        String oldEncoding = ENCODING;
        ENCODING = newEncoding;
        return oldEncoding;
    }

    @Override
    public String getCookieValue(String cookieName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCookie(String cookieName, String cookieValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveBiBusHeaderTo(Envelope target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyBiBusHeaderTo(Envelope target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BodyHandler getBodyHandler() {
        if (this.bodyHandler == null) {
            this.setBodyHandler(new Dom4jBodyHandler(this));
        }
        return this.bodyHandler;
    }

    protected void setBodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
    }

    @Override
    public BodyFault getBodyFault() {
        if (this.bodyFault == null) {
            this.setBodyFault(new Dom4jBodyFault(this));
        }
        return this.bodyFault;
    }

    @Override
    public void setBodyFault(BodyFault bodyFault) {
        this.bodyFault = bodyFault;
    }

    @Override
    public void copyBodyFaultTo(Envelope target) {
        SOAPEnvelope soapTarget = (SOAPEnvelope)target;
        soapTarget.setFault(this.getFault().createCopy());
    }

    private void setFault(Element fault) {
        this.removeOldFault();
        this.getBody().add(fault);
    }

    private void removeOldFault() {
        Element oldFault = this.getFault();
        if (oldFault != null) {
            oldFault.detach();
        }
    }

    public SOAPEnvelope toDom4j() throws Exception {
        return this.toDom4j(null);
    }

    public SOAPEnvelope toDom4j(InputStream stream) throws Exception {
        return this;
    }

    public SOAPEnvelope toStax(BodyHandler bodyHandler) throws Exception {
        return this.toStax(bodyHandler, null);
    }

    public SOAPEnvelope toStax(BodyHandler bodyHandler, InputStream stream) throws Exception {
        return this;
    }
}

