/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.common;

import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.EnvelopeFactory;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelopeFactory;
import com.cognos.pogo.pdk.stax.StaxEnvelopeFactory;

public class EnvelopeFactorySelector {
    private static final String ENVELOPE_FACTORY_PROPERTY = "envelope.factory";
    private static StaxEnvelopeFactory staxEnvelopeFactory = new StaxEnvelopeFactory();
    private static Dom4jEnvelopeFactory dom4jEnvelopeFactory = new Dom4jEnvelopeFactory();

    public static EnvelopeFactory getFactoryFor(String parserType) {
        return staxEnvelopeFactory.isCompatibleWith(parserType) ? staxEnvelopeFactory : EnvelopeFactorySelector.getDefaultFactory();
    }

    public static EnvelopeFactory getFactoryFor(Envelope envelope) {
        return EnvelopeFactorySelector.isStaxEnvelope(envelope) ? staxEnvelopeFactory : EnvelopeFactorySelector.getDefaultFactory();
    }

    public static EnvelopeFactory getFactoryFor(MessageContext mc) {
        EnvelopeFactory factory = mc != null ? (EnvelopeFactory)mc.getProperty(ENVELOPE_FACTORY_PROPERTY) : null;
        return factory != null ? factory : EnvelopeFactorySelector.getDefaultFactory();
    }

    public static void setFactory(MessageContext mc, String parserType) {
        mc.setProperty(ENVELOPE_FACTORY_PROPERTY, EnvelopeFactorySelector.getFactoryFor(parserType));
    }

    public static void removeFactory(MessageContext mc) {
        mc.setProperty(ENVELOPE_FACTORY_PROPERTY, null);
    }

    public static EnvelopeFactory getDefaultFactory() {
        return dom4jEnvelopeFactory;
    }

    public static String getParserType(MessageContext mc) {
        EnvelopeFactory factory = EnvelopeFactorySelector.getFactoryFor(mc);
        return factory.getParserType();
    }

    public static boolean isStaxRequest(MessageContext mc) {
        return EnvelopeFactorySelector.getFactoryFor(mc) == staxEnvelopeFactory;
    }

    public static boolean isStaxEnvelope(Envelope envelope) {
        return staxEnvelopeFactory.isCompatibleWith(envelope);
    }
}

