/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.common;

import com.cognos.pogo.pdk.common.EnvelopeElement;
import com.cognos.pogo.pdk.common.UserCapabilityCacheException;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.capability.UserCapabilityBitEncoder;
import java.net.URLDecoder;
import java.util.List;

public abstract class UserCapabilityCache
implements EnvelopeElement {
    protected static PogoLogger log = PogoLogger.getLogger();
    private static final String SIGNATURE_SEPARATOR = "&";

    public abstract void addCapabilities(List<String> var1);

    public abstract void addSignature(String var1);

    public abstract boolean hasItem(String var1);

    public abstract int getNrOfItems();

    public abstract String getSignature();

    @Deprecated
    public boolean validateCookie(String cookie, CAMUtils camUtils) throws UserCapabilityCacheException {
        return this.validateCookie(cookie, null, camUtils);
    }

    public boolean validateCookie(String cookie, String passportID, CAMUtils camUtils) throws UserCapabilityCacheException {
        String signature = this.parseAndStoreCookie(this.urlDecode(cookie));
        return this.verifyTrust(signature, passportID, camUtils);
    }

    public String parseAndStoreCookie(String cookie) throws UserCapabilityCacheException {
        String[] splitCookie = cookie.split(SIGNATURE_SEPARATOR);
        return this.parseAndStoreCookie(splitCookie);
    }

    private String parseAndStoreCookie(String[] splitCookie) throws UserCapabilityCacheException {
        if (this.isEmptyCookie(splitCookie)) {
            return null;
        }
        this.throwIfCookieIsInvalid(splitCookie);
        List<String> capabilities = this.decodeCapabilities(splitCookie);
        String signature = this.decodeSignature(splitCookie);
        this.throwIfNotSigned(capabilities, signature);
        this.storeDecodedValues(capabilities, signature);
        return signature;
    }

    private boolean isEmptyCookie(String[] split) {
        return split.length == 1 && split[0].equals("");
    }

    private void throwIfCookieIsInvalid(String[] splitCookie) throws UserCapabilityCacheException {
        if (splitCookie.length != 2) {
            throw new UserCapabilityCacheException("Improperly signed cookie");
        }
    }

    private List<String> decodeCapabilities(String[] splitCookie) throws UserCapabilityCacheException {
        UserCapabilityBitEncoder bitEncoder = new UserCapabilityBitEncoder(splitCookie[0]);
        return bitEncoder.decode();
    }

    private String decodeSignature(String[] splitCookie) {
        return splitCookie[1];
    }

    private void throwIfNotSigned(List<String> capabilities, String signature) throws UserCapabilityCacheException {
        if (signature == null && !capabilities.isEmpty()) {
            throw new UserCapabilityCacheException("Signature not present");
        }
    }

    protected void storeDecodedValues(List<String> capabilities, String signature) {
        this.addCapabilities(capabilities);
        this.addSignature(signature);
    }

    private String urlDecode(String cookie) throws UserCapabilityCacheException {
        try {
            return URLDecoder.decode(cookie, "UTF-8");
        }
        catch (Exception e) {
            throw new UserCapabilityCacheException("Unable to decode cookie: " + cookie, e);
        }
    }

    private boolean verifyTrust(String signature, String passportID, CAMUtils camUtils) {
        try {
            return camUtils.verifyTrustToken(signature.getBytes("utf-8"), this.asXML().getBytes("utf-8"), passportID);
        }
        catch (Exception e) {
            log.warn("Exception while verifying signature ", e);
            return false;
        }
    }
}

