/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.CAMPassport;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Dom4jCAMPassport
extends Dom4jBase
implements CAMPassport {
    private final BIBusEnvelope envelope;

    public Dom4jCAMPassport(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public boolean canCallLogon() {
        return this.getBooleanValue("canCallLogon", false);
    }

    private boolean getBooleanValue(String elementName, boolean defaultValue) {
        Element child = this.getCamPassportChildElement(elementName);
        return child != null ? Boolean.parseBoolean(child.getText()) : defaultValue;
    }

    private Element getCamPassportChildElement(String childName) {
        Element camPassport = this.getOptionalCamPassportElement();
        Element child = camPassport != null ? camPassport.element(childName) : null;
        return Dom4jCAMPassport.isXsiNil(child) ? null : child;
    }

    private Element getOptionalCamPassportElement() {
        Element cam = this.envelope.getOptionalCAM();
        return cam != null ? cam.element("CAMPassport") : null;
    }

    @Override
    public int getGeneration() {
        Element generation = this.getCamPassportChildElement("generation");
        return generation != null ? Dom4jCAMPassport.parseInt("generation", generation.getText(), 0) : 0;
    }

    @Override
    public String getId() {
        Element id = this.getCamPassportChildElement("id");
        String idText = id != null ? id.getText() : null;
        return StringUtils.isEmpty((String)idText) ? null : idText;
    }

    @Override
    public boolean isAnonymous() {
        return this.getBooleanValue("isAnonymous", false);
    }

    @Override
    public boolean isLogEnabled() {
        Element camPassport = this.getOptionalCamPassportElement();
        if (camPassport == null) {
            return true;
        }
        Element logEnabledElement = camPassport.element("logEnabled");
        if (Dom4jCAMPassport.isNil(logEnabledElement)) {
            return false;
        }
        String logEnabledText = logEnabledElement.getText();
        return StringUtils.isEmpty((String)logEnabledText) ? true : Boolean.valueOf(logEnabledText);
    }

    @Override
    public boolean isShareable() {
        return this.getBooleanValue("shareable", false);
    }

    @Override
    public void setAnonymous(Boolean isAnonymous) {
        this.setCamPassportChildElement("isAnonymous", BIBusEnvelope.XSD_BOOLEAN, isAnonymous);
    }

    private void setCamPassportChildElement(String name, String type, Object value) {
        Element camPassport = this.getOrCreateCamPassport();
        if (value != null) {
            Dom4jCAMPassport.setChildElementText(camPassport, name, type, value.toString());
        } else {
            this.removeChildElement(camPassport, name);
        }
    }

    private Element getOrCreateCamPassport() {
        Element cam = this.envelope.getCAM();
        return Dom4jCAMPassport.getOrCreateChildElement(cam, "CAMPassport", BIBusEnvelope.BUS_CAMPASSPORT.getQualifiedName());
    }

    @Override
    public void setCanCallLogon(Boolean canCallLogon) {
        this.setCamPassportChildElement("canCallLogon", BIBusEnvelope.XSD_BOOLEAN, canCallLogon);
    }

    @Override
    public void setGeneration(Integer generation) {
        this.setCamPassportChildElement("generation", BIBusEnvelope.XSD_INT, generation);
    }

    @Override
    public void setId(String id) {
        this.setCamPassportChildElement("id", BIBusEnvelope.XSD_STRING, id);
    }

    @Override
    public void setLogEnabled(Boolean isLogEnabled) {
        this.setCamPassportChildElement("logEnabled", BIBusEnvelope.XSD_BOOLEAN, isLogEnabled);
    }

    @Override
    public void setShareable(Boolean isShareable) {
        this.setCamPassportChildElement("shareable", BIBusEnvelope.XSD_BOOLEAN, isShareable);
    }

    @Override
    public String asXML() {
        Element camPassport = this.getOptionalCamPassportElement();
        return camPassport != null ? camPassport.asXML() : null;
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent();
    }

    @Override
    public boolean isPresent() {
        return this.getOptionalCamPassportElement() != null;
    }
}

