/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Caf;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import org.dom4j.Element;

public class Dom4jCaf
extends Dom4jBase
implements Caf {
    private static final String CONTEXT_ID = "contextID";
    private final BIBusEnvelope envelope;

    public Dom4jCaf(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public String getSecureState() {
        return this.envelope.getCAFSecureState();
    }

    @Override
    public void setSecureState(String secureState) {
        this.envelope.setCAFSecureState(secureState);
    }

    @Override
    public String getContextID() {
        return this.getElementText(CONTEXT_ID);
    }

    @Override
    public void setContextID(String contextID) {
        Element mandatoryCaf = this.getMandatoryCAF();
        Dom4jCaf.setChildElementText(mandatoryCaf, CONTEXT_ID, BIBusEnvelope.XSD_STRING, contextID);
    }

    private String getElementText(String name) {
        Element optionalCaf = this.getOptionalCAF();
        return optionalCaf != null ? optionalCaf.elementText(name) : null;
    }

    private Element getOptionalCAF() {
        return this.envelope.getBIBusHeader().element(Dom4jEnvelope.BUS_CAF.getName());
    }

    private Element getMandatoryCAF() {
        return this.envelope.getMandatoryElement(this.envelope.getBIBusHeader(), BIBusEnvelope.BUS_CAF);
    }

    @Override
    public String asXML() {
        Element optionalCaf = this.getOptionalCAF();
        return optionalCaf != null ? optionalCaf.asXML() : null;
    }

    @Override
    public boolean isEmpty() {
        Element optionalCaf = this.getOptionalCAF();
        return optionalCaf == null || optionalCaf.elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        return this.envelope.hasOptionalElement(Dom4jEnvelope.BUS_CAF);
    }
}

